
/**
 * Title:        HobiLabs data processing<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Brian Schlining<p>
 * Company:      MBARI<p>
 * @author Brian Schlining
 * @version 1.0 06 Nov 2000
 */
package org.mbari.oasis;

import java.util.*;

/**
 * Contains methods for storing and retrieving calibration history information
 * for MBARI moorings. A List for storing calibraion history information.
 * @see CalibrationHistoryFactory
 *
 */
public class CalibrationHistory {

   /**
    * Default Constructor. If you use this call setInstrumentType Later on.
    */
   public CalibrationHistory() {
   }

   /**
    * Adds the isntrument type to the list.
    * @param instrumentType The ID for this isntrument type
    */
   public CalibrationHistory(String instrumentType) {
      this.instrumentType = instrumentType;
   }

   /**
    * Useful for setting or changing the instrument type
    * @param instrumentType The ID for the type of instrument
    */
   protected void setInstrumentType(String instrumentType) {
      this.instrumentType = instrumentType;
   }

   /**
    * Returns the type of instrument calibrations stored in this object
    */
   public String getInstrumentType() {
      return this.instrumentType;
   }

   /**
    * Sets the default calibration file
    * @param default cal
    */
   public void setDefault(String defaultCal) {
      this.defaultCal = defaultCal;
   }

   /**
    * returns the default calibration. However the prefered use is to use
    * the get(calDate) method. This will return the appropriate calibration
    * file to use for a particular date.
    */
   public String getDefault() {
      return this.defaultCal;
   }

   /**
    * Adds a calibration file to the history.
    * @param startDate The inclusive time that specifies when this cali file is valid
    * @param endDate The inclusive time that specifies when this cla file is no longer valid.
    * @parm cal The name of the calibration file
    */
   public void set(Date startDate, Date endDate, String cal) {
      this.set(startDate.getTime(), endDate.getTime(), cal);
   }

   /**
    * Adds a calibration file to the history.
    * @param startDate The inclusive time that specifies when this cali file is valid
    * @param endDate The inclusive time that specifies when this cla file is no longer valid.
    * @parm cal The name of the calibration file
    */
   public void set(long startDate, long endDate, String cal) {
      this.cals.add(cal);
      this.start.add(new Long(startDate));
      this.end.add(new Long(endDate));
   }

   /**
    * Returns the name of the correct calibration file to use based on date
    * @param calDate A date objec representing the date of sample
    */
   public String get(Date calDate) {
      return this.get(calDate.getTime());
   }

   /**
    * Returns the name of the correct calibration file to use based on date
    * @param calDate Millisec since epoch representing the date of sample.
    */
   public String get(long calDate) {
      int i;
      Long s, e;
      String cal = null;
      for (i = 0; i <= cals.size(); i++) {
         if (i == cals.size()) {
            cal = this.getDefault();
         }
         s = (Long) start.get(i);
         e = (Long) end.get(i);
         if ((calDate >= s.longValue()) & (calDate <= e.longValue())) {
            cal = (String) cals.get(i);
            break;
         }
      }
      return cal;

   }

   private String defaultCal,
                  instrumentType;
   private ArrayList cals = new ArrayList();
   private ArrayList start = new ArrayList();
   private ArrayList end = new ArrayList();

}