package org.mbari.ma2;

import ucar.ma2.*;

/**
 * Title:        mbariMoos web application project
 * Description:  The goal of this project is to develop server side processes for use in disseminating OASIS and MOOS data sets.
 * Copyright:    Copyright (c) 2001
 * Company:      MBARI
 *
 * Functions (i.e static methods) for operating on Multiarray (version 2) (ucar.ma2.*)
 * @author Brian Schlining
 * @version 31 Jul 2001
 *
 */
public class Ma2Util {

    private Ma2Util() {
        // Do not allow instantiation
    }

    /**
     * Search a multiarray using a binary search
     * @param ma The interface ucar.ma2.Array to search
     * @param key The value to search for
     * @param keyDimension Specifies the index of the dimension to search
     * for example if its a 2-D array and the first dimension contains the keyD
     * the keyDimension = 0
     * @return index of the search key, if it is contained in the list;
     * otherwise, <tt>(-(<i>insertion point</i>) - 1)</tt>.  The
     * <i>insertion point</i> is defined as the point at which the
     * key would be inserted into the list: the index of the first
     * element greater than the key, or <tt>list.size()</tt>, if all
     * elements in the list are less than the specified key.  Note
     * that this guarantees that the return value will be &gt;= 0 if
     * and only if the key is found.
     */
    public static int binarySearch(Array ma, long key, int keyDimension) {
        int[] shape  = ma.getShape();
        int[] origin = new int[shape.length];
        Index ind    = ma.getIndex();
        ind.set(origin);

        int low = 0;
        int high = shape[keyDimension] - 1;

        while (low <= high) {
            int mid =(low + high)/2;
            origin[keyDimension] = mid;
            ind.set(origin);
            long midVal = ma.getLong(ind);

            if (midVal < key) {
                low = mid + 1;
            } else if (midVal > key) {
                high = mid - 1;
            } else {
                return mid; // key found
            }
        }
        return -(low + 1);  // key not found.
    }
}