
/** Description:  Reads data files created by Bob Herlein's extract program into a
 * Double array.<BR><BR>
 *
 * @author Brian Schlining
 * @version 28 Sep 1999
 */
package org.mbari.io;

import java.io.*;
import java.text.*;
import java.util.*;
import org.mbari.io.*;
import org.mbari.util.*;

/**
 * Reads files created by Bob Herlein's extract program and combined using
 * <i>concat.awk</i> or <i>OasisFileCoallator.java</i> into a double array
 */
public class OasisFileReader extends FlatFileReader {

   /////////////////////////////////////////
   // Constructors
   /**
    * Constructor makes a quick pass through the file to intialize memory.
    * To read the file call the readFile method.
    *
    * @param s  The name of the file to read
    */
   public OasisFileReader(String s) throws IOException {
      super(s);
   }

   /**
    * @param f  File object representing the file to be read
    */
   public OasisFileReader(File f) throws IOException {
      super(f);
   }

   /////////////////////////////////////////
   // Accessors
   /**
    * Accessor method to get the time stamp for each line of data in the data
    * array
    *
    * @returns  A long array of time in UTC format. The units are
    *  milliseconds since January 1, 1970 00:00:00 UTC
    */
   public long[] getTime() {
      return this.time;
   }

   /////////////////////////////////////////
   // Public Methods
   /**
    * Read a data file. Rarses data that are seperated by
    * white spaces or tabs
    */
   public void readFile() throws IOException {
      super.readFile();
      this.setTime();
   }

   /**
    * Read a data file. Parse lines based on the string token specified
    *
    * @param delims A string that deliminates the data in the file to be read
    */
   //public void readFile(String delims) throws IOException {}

   /////////////////////////////////////////
   // Private Methods
   private void setTime() {
      for (int i = 0; i < super.countRows(); i++) {
         time[i] = DateConverter.doyToDate(super.data[i][0],
                    super.data[i][super.countColumns()-1]).getTime();
      }
   }

   /////////////////////////////////////////
   // Class Variables
   private long[] time = new long[super.countRows()];

}