
/**
 * Title:        HobiLabs data processing<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Brian Schlining<p>
 * Company:      MBARI<p>
 * @author Brian Schlining
 * @version 1.0
 */
package org.mbari.hobilabs;

public class HSDParser {

  /**
   * HSDParser parses data packets from a Hoblilabs HS2. This parser is not
   * intantiable. Instead, use it as:<br><br>
   *
   * HSDPacket p = HSDParser.parse(String datastring);
   */
   private HSDParser() {
      // No instantiation, this class contains all static methods
   }

   /**
    * @param s A string of hex ascii from a HS2 data packet
    */
   public static HSDPacket parse(String S) throws IllegalArgumentException {

      // Is the string a data packet?
      if (!S.startsWith("*D") || (S.length() < 59)) {
         throw new IllegalArgumentException("Invalid Data Packet");
      }

      // Does it contain a valid checksum?
      /*int checkSum = 0;
      for (int i = 1; i < 21; i++) {   // Sum up
         checkSum += Integer.parseInt(S.substring(i, i+1), 16);
      }
      String checkHex = Integer.toHexString(checkSum);
      int n = checkHex.length();
      int leastByte = checkHex.substring(n-2, n);
      if (Integer.parseInt(leastByte, 16) != Integer.parseInt(substring(58, 60), 16)) {
         throw new IllegalArgumentExcetion("Error in data packet");
      }*/

      // Break the string apart into its words
       String[] hex = new String[21];
       hex[0]  = S.substring(2, 10);   // Time
       hex[1]  = S.substring(10, 14);  // snorm1
       hex[2]  = S.substring(14, 18);  // snorm2
       hex[3]  = S.substring(18, 22);  // snorm3
       hex[4]  = S.substring(22, 26);  // snorm4
       hex[5]  = S.substring(26, 30);  // snorm5
       hex[6]  = S.substring(30, 34);  // snorm6
       hex[7]  = S.substring(34, 38);  // snorm7
       hex[8]  = S.substring(38, 42);  // snorm8
       hex[9]  = S.substring(42, 43);  // gain1
       hex[10] = S.substring(43, 44);  // gain2
       hex[11] = S.substring(44, 45);  // gain3
       hex[12] = S.substring(45, 46);  // gain4
       hex[13] = S.substring(46, 47);  // gain5
       hex[14] = S.substring(47, 48);  // gain6
       hex[15] = S.substring(48, 49);  // gain7
       hex[16] = S.substring(49, 50);  // gain8
       hex[17] = S.substring(50, 54);  // depth
       hex[18] = S.substring(54, 56);  // temperature
       hex[19] = S.substring(56, 58);  // error
       hex[20] = S.substring(58, 60);  // checksum

       int hexIndex = 0;
       long time = ((long) toSignedInt(hex[hexIndex]))*1000; // Time in epic millisec
       hexIndex++;

       int[] sNorm = new int[8];
       for (int i = 0; i < sNorm.length; i++) {
          sNorm[i] = toSignedInt(hex[hexIndex]);
          hexIndex++;
       }

       int[] gain = new int[8];
       for (int i = 0; i < gain.length; i++) {
          gain[i] = Integer.parseInt(hex[hexIndex]);
          hexIndex++;
       }

       int depth = toSignedInt(hex[hexIndex]);
       hexIndex++;

       int temperature = Integer.parseInt(hex[hexIndex], 16);
       hexIndex++;

       byte error = (byte) Integer.parseInt(hex[hexIndex], 16);

       hex = null;  // make GC easier

       return new HSDPacket(time, sNorm, gain, depth, temperature, error);
   }

   /**
    * Convert hexadecmal values to signed integers
    */
   private static int toSignedInt(String S) {

      int i = Integer.parseInt(S, 16);       // Convert hex to int
      int L = S.length();                    // Count byte-words in the hex string
      //long max = (long) Math.pow(2d, L*8D);  // Calc the maximum unsigned value
      long maxValue = 0;
      long minValue = 0;

      if (L == 4) {
         maxValue = (long) Short.MAX_VALUE;
         minValue = (long) Short.MIN_VALUE;
      } else if (L == 8) {
         maxValue = (long) Integer.MAX_VALUE;
         minValue = (long) Integer.MIN_VALUE;
      }


      if ((long) i > maxValue) {
         i = i + (int) minValue * 2;
      }

      return i;

   }



}