
/**
 * Title:        HobiLabs data processing<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Brian Schlining<p>
 * Company:      MBARI<p>
 * @author Brian Schlining 18 Oct 2000
 * @version 1.0
 */
package org.mbari.hobilabs;

/**
 * Concrete subclass of HSPacket. This class holds the "D" or data type of packet
 */
public class HSDPacket extends HSPacket {

   /**
    * All the values are assigned in the constructor.
    * @param time_ Time of sample
    * @param sNorm_
    * @param gain_
    * @param depth_
    * @param temperature_
    * @param error_
    */
   public HSDPacket(long time_, int[] sNorm_, int[] gain_, int depth_, int temperature_, byte error_) {
      super("D");
      this.time = time_;
      this.sNorm = sNorm_;
      this.gain = gain_;
      this.depth = depth_;
      this.error = error_;
   }

   public long getTime() {
      return time;
   }

   public int[] getSnorm() {
      return sNorm;
   }

   public int getSnorm(int i) {
      return sNorm[i];
   }

   public int[] getGain() {
      return gain;
   }

   public int getGain(int i) {
      return gain[i];
   }

   public int getDepth() {
      return depth;
   }

   public int getTemperature() {
      return temperature;
   }

   private long  time;
   private int[] sNorm,
                 gain;
   private byte  error;
   private int   depth,
                 temperature;
}