
/**
 * Title:        HobiLabs data processing<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Brian Schlining<p>
 * Company:      MBARI<p>
 * @author Brian Schlining
 * @version 1.0
 */
package org.mbari.hobilabs;

/**
 * This does not use the traditional Java encapsulation of data. Instead it
 * Correspongs more to a struct in C. All class variables are publically excessable.
 */
public class HRPacket {

   public int    RawTime,     // Sample time in Epic seconds
                 IntTime,     // Integration time in millisec
                 FirstPix,    // Index of first pixel on CCD that's reported
                 PixInc,      // Increment to next pixel on CCD
                 PixCount,    // Total number of pixels (starts counting at 0)
                 Process,     // Level of processing 0 = raw; 4 = calibrated in EU
                 N;           // Number of samples averaged

   public double Temp,        // Internal Temperature (C)
                 Voltage,     // Supply voltage (V)
                 Depth,       // Depth of instrument (meters)
                 Scale,       // Always == 1
                 Do,          // Ignore
                 Dt;          // Ignore

   public double[] Pixel;     // Data

}