
/**
 * Title:        HobiLabs data processing<p>
 * Description:  <p>
 * Copyright:    Copyright (c) Brian Schlining<p>
 * Company:      MBARI<p>
 * @author Brian Schlining
 * @version 0.1 23 Oct 2000
 *
 */
package org.mbari.hobilabs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;


/**
 * This is not a complete reader yet. Currently it simply returns the A Wave
 * info, used for calculating wavelength and the serialNumber of the calibration
 * file.
 */
public class HRCalibrationFileReader {

   public HRCalibrationFileReader(File calfile) throws IOException {
      this.calfile = calfile;
      this.read();
   }

   public HRCalibrationFileReader(String calfile) throws IOException {
      this(new File(calfile));
   }

   private void read() throws IOException {
      ////////////////////////
      // Read the needed info from the cal file
      String calString = null;

      BufferedReader cal = new BufferedReader(new FileReader(calfile));

      while ((calString = cal.readLine()) != null) {
         if (calString.trim().equals("[ID]")) {
            serialNumber = cal.readLine().trim();
            continue;
         }
         if (calString.trim().equals("[A WAVE]")) {
            A[0] = Double.parseDouble(cal.readLine());
            A[1] = Double.parseDouble(cal.readLine());
            A[2] = Double.parseDouble(cal.readLine());
            continue;
         }
         if (calString.trim().equals("[B WAVE]")) {
            B[0] = Double.parseDouble(cal.readLine());
            B[1] = Double.parseDouble(cal.readLine());
            B[2] = Double.parseDouble(cal.readLine());
            continue;
         }
         if (calString.trim().equals("[C WAVE]")) {
            C[0] = Double.parseDouble(cal.readLine());
            C[1] = Double.parseDouble(cal.readLine());
            C[2] = Double.parseDouble(cal.readLine());
            continue;
         }
         if (calString.trim().equals("[D WAVE]")) {
            D[0] = Double.parseDouble(cal.readLine());
            D[1] = Double.parseDouble(cal.readLine());
            D[2] = Double.parseDouble(cal.readLine());
            continue;
         }
      }

      if ((serialNumber == null) || (A[0] == 0) || (A[1] == 0) || (A[2] == 0)) {
         throw new IOException(calfile.getCanonicalPath() +  " is not a valid " +
            "calibration file");
      }

      cal.close();
   }

   public double[] getAWave() {
      return this.A;
   }

   public double[] getBWave() {
      return this.B;
   }

   public double[] getCWave() {
      return this.C;
   }

   public double[] getDWave() {
      return this.D;
   }

   public double[] getWave(int channel) throws IllegalArgumentException {
      double[] W;
      switch (channel) {
         case 1:
            W = this.getAWave();
            break;
         case 2:
            W = this.getBWave();
            break;
         case 3:
            W = this.getCWave();
            break;
         case 4:
            W = this.getDWave();
            break;
         default:
            throw new IllegalArgumentException("'" + channel + "' is not a valid channel." +
             "Valid channels are A,B,C,D or 1,2,3,4.");
      }
      return W;
   }

   public double[] getWave(String channel) throws IllegalArgumentException {
      int i;
      if (channel.toLowerCase().equals("a") | channel.equals("1")) {
         i = 1;
      } else if (channel.toLowerCase().equals("b") | channel.equals("2")) {
         i = 2;
      } else if (channel.toLowerCase().equals("c") | channel.equals("3")) {
         i = 3;
      } else if (channel.toLowerCase().equals("d") | channel.equals("4")) {
         i = 4;
      } else {
         throw new IllegalArgumentException("'" + channel + "' is not a valid channel." +
          "Valid channels are A,B,C,D or 1,2,3,4.");
      }
      return this.getWave(i);
   }

   public String getID() {
      return this.serialNumber;
   }

   private File calfile;
   private double[] A = new double[3];private double[] B = new double[3];private double[] C = new double[3];private double[] D = new double[3];
   private String serialNumber;
}