package org.mbari.gis;

import org.mbari.io.*;
import org.mbari.gis.util.*;
import java.util.ArrayList;
import java.util.Iterator;
import java.awt.geom.Point2D;
import java.io.IOException;

public class Drazen {
	public static void main(String args[]) {

        	DelimitedFile df = null;
        	try {
            df = new DelimitedFile(args[0]);
            df.setHasColumnNames(true);
            df.read();
        }
            catch (IOException e) {
				e.printStackTrace();
            }

            int latColumn = 4;
            int lonColumn = 5;

            int rowCount = df.getNumOfRows();
            double[][] data = df.getData();

            ArrayList p = new ArrayList(2000);
            double lat;
            double lon;
            for(int row = 0; row < rowCount -1 ; row++){
                lon = data[row][ lonColumn];
                lat = data[row][ latColumn];
                p.add(GisUtil.geoToUtm(lon, lat, 10));
            }

            int rows = p.size();
            double d = 0.0;
            for(int i = 1; i < rows; i++) {
                Point2D p1 = (Point2D) p.get(i - 1);
                Point2D p2 = (Point2D) p.get(i);
				d = d + Math.abs(p2.distance(p1));
            }

            System.out.println("Track for file, " + args[0] + " is " + d);

	}
}


