/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.util;

import java.util.Date;
import org.mbari.util.GmtCalendar;
import org.mbari.util.MathUtil;
import org.mbari.util.TimeUtil;

public class SolarPosition {
    public double altitude;
    public double zenith;
    public double azimuth;
    public double distance;
    public double latitude;
    public double longitude;
    public long time;

    public SolarPosition(long millis, double latitude, double longitude) {
        this.time = millis;
        this.longitude = longitude * Math.PI / 180.0;
        this.latitude = latitude * Math.PI / 180.0;
        this.getSolarPosition();
    }

    public SolarPosition(Date date, double latitude, double longitude) {
        this(date.getTime(), latitude, longitude);
    }

    private void getSolarPosition() {
        double solarAltitude;
        int sign2;
        GmtCalendar gc = new GmtCalendar(this.time);
        double hour = gc.get(11);
        double minute = gc.get(12);
        double second = gc.get(13);
        double decimalHour = hour + (minute + second / 60.0) / 60.0;
        double julianDate = TimeUtil.getJulianDate(this.time) + decimalHour / 24.0;
        double days2000 = julianDate - 2451545.0;
        double cent1900 = 1.0 + days2000 / 36525.0;
        double gmst = 6.6460656 + 2400.051262 * cent1900 + 2.58E-5 * Math.pow(cent1900, 2.0);
        gmst = MathUtil.rem(gmst, 24.0);
        double P10 = Math.PI * 2 * (0.827362 + 0.03386319198 * days2000);
        double P11 = Math.PI * 2 * (0.347343 - 1.4709391E-4 * days2000);
        double P12 = Math.PI * 2 * (0.779072 + 0.00273790931 * days2000);
        double P13 = Math.PI * 2 * (0.993126 + 0.0027377785 * days2000);
        double P14 = Math.PI * 2 * (0.140023 + 0.00445036173 * days2000);
        double P15 = Math.PI * 2 * (0.053856 + 0.00145561327 * days2000);
        double P16 = Math.PI * 2 * (0.056531 + 2.3080893E-4 * days2000);
        double P17 = (6910.0 - 17.0 * cent1900) * Math.sin(P13);
        P17 += 72.0 * Math.sin(2.0 * P13);
        P17 -= 7.0 * Math.cos(P13 - P16);
        P17 += 6.0 * Math.sin(P10);
        P17 += 5.0 * Math.sin(4.0 * P13 - 8.0 * P15 + 3.0 * P16);
        P17 -= 5.0 * Math.cos(2.0 * P13 - 2.0 * P14);
        P17 -= 4.0 * Math.sin(P13 - P14);
        P17 += 4.0 * Math.cos(4.0 * P13 - 8.0 * P15 + 3.0 * P16);
        P17 += 3.0 * Math.sin(2.0 * P13 - 2.0 * P14);
        P17 -= 3.0 * Math.sin(P16);
        P17 -= 3.0 * Math.sin(2.0 * P13 - 2.0 * P16);
        double P18 = (0.39785 - 2.1E-4 * cent1900) * Math.sin(P12);
        P18 += (3.0E-5 * cent1900 - 0.01) * Math.sin(P12 - P13);
        P18 += 0.00333 * Math.sin(P12 + P13);
        P18 += 4.0E-5 * Math.sin(P12 + 2.0 * P13);
        P18 -= 4.0E-5 * Math.cos(P12);
        P18 -= 4.0E-5 * Math.sin(P11 - P12);
        double P19 = (-3349.0 + 8.0 * cent1900) * Math.cos(P13);
        P19 -= 14.0 * Math.cos(2.0 * P13);
        P19 -= 3.0 * Math.sin(P13 - P16);
        P19 = 1.0 + P19 / 100000.0;
        double P20 = (-0.04129 + 5.0E-5 * cent1900) * Math.sin(2.0 * P12);
        P20 += (0.03211 - 8.0E-5 * cent1900) * Math.sin(P13);
        P20 += 0.00104 * Math.sin(2.0 * P12 - P13);
        P20 = P20 - 3.5E-4 * Math.sin(2.0 * P12 + P13) - 1.0E-4;
        P20 -= 8.0E-5 * Math.sin(P11);
        P20 += 7.0E-5 * Math.sin(2.0 * P13);
        P20 += 3.0E-5 * Math.sin(P10);
        P20 -= 2.0E-5 * Math.cos(P13 - P16);
        P20 += 2.0E-5 * Math.sin(4.0 * P13 - 8.0 * P15 + 3.0 * P16);
        P20 -= 2.0E-5 * Math.sin(P13 - P14);
        double equationOfTime = Math.asin((P20 -= 2.0E-5 * Math.cos(2.0 * P13 - 2.0 * P14)) / Math.sqrt(P19 - P18 * P18));
        double earthSunDistance = 1.00021 * Math.sqrt(P19);
        double declination = Math.asin(P18 / Math.sqrt(P19));
        double meanRightAscension = P12;
        double rightAscension = meanRightAscension + equationOfTime;
        double ghaAries = 15.0 * (gmst + decimalHour) * Math.PI / 180.0;
        double gha = ghaAries - rightAscension;
        gha = MathUtil.rem(gha, Math.PI * 2);
        double sha = Math.PI * 2 + rightAscension;
        double sunLongitude = meanRightAscension + P17 / 3600.0;
        double longitudeRadians = -this.longitude;
        double latitudeRadians = this.latitude;
        double lha = gha - longitudeRadians;
        double solarZenith = Math.acos(Math.sin(latitudeRadians) * Math.sin(declination) + Math.cos(latitudeRadians) * Math.cos(declination) * Math.cos(lha));
        double solarAzimuth = Math.acos((-Math.sin(latitudeRadians) * Math.cos(lha) * Math.cos(declination) + Math.sin(declination) * Math.cos(latitudeRadians)) / Math.sin(solarZenith));
        int sign1 = MathUtil.sign(-Math.cos(declination) * Math.sin(lha) / Math.sin(solarZenith));
        if (sign1 != (sign2 = MathUtil.sign(Math.sin(solarAzimuth)))) {
            solarAzimuth = Math.PI * 2 - solarAzimuth;
        }
        this.altitude = solarAltitude = 1.5707963267948966 - solarZenith;
        this.zenith = solarZenith;
        this.distance = earthSunDistance;
        this.azimuth = solarAzimuth;
    }
}

