/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.test;

import java.util.HashSet;
import java.util.Iterator;
import org.mbari.test.IPointListener;
import org.mbari.test.Point;

public class RandomWalk {
    private volatile long delay;
    private volatile Point point = new Point(0.0, 0.0);
    private HashSet listeners = new HashSet();
    private Thread walkThread;
    private volatile boolean isRunning = true;

    public RandomWalk() {
        this(1000L);
    }

    public RandomWalk(long delay) {
        this.delay = delay;
        Runnable r = new Runnable(){

            public void run() {
                try {
                    RandomWalk.this.runThis();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.walkThread = new Thread(r);
    }

    public void start() {
        this.isRunning = true;
        this.walkThread.start();
    }

    public void stop() {
        this.isRunning = false;
        if (this.walkThread != null) {
            this.walkThread.interrupt();
        }
    }

    public synchronized void reset() {
        this.point.setX(0.0);
        this.point.setY(0.0);
    }

    public boolean isAlive() {
        return this.walkThread.isAlive();
    }

    public void addPointListener(Object o) {
        this.listeners.add(o);
    }

    public void removePointListener(Object o) {
        this.listeners.remove(o);
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    private void runThis() {
        while (this.isRunning) {
            double x = Math.floor(Math.random() * 3.0) - 1.0;
            double y = Math.floor(Math.random() * 3.0) - 1.0;
            this.point.setX(this.point.getX() + x);
            this.point.setY(this.point.getY() + y);
            this.notifyListeners();
            System.out.println("dx = " + x + ", dy = " + y);
            System.out.println("Current Position: x = " + this.point.getX() + ", y = " + this.point.getY());
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void notifyListeners() {
        if (this.listeners != null) {
            Iterator iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                IPointListener listener = (IPointListener)iterator.next();
                try {
                    listener.update(this.point);
                }
                catch (Exception e) {
                    System.err.println("Failed update call to " + listener);
                    System.err.println("  " + e.getMessage());
                    e.printStackTrace();
                    this.removePointListener(listener);
                }
            }
        }
    }

    public static void main(String[] args) {
        RandomWalk rw = null;
        switch (args.length) {
            case 0: {
                rw = new RandomWalk();
                break;
            }
            case 1: {
                rw = new RandomWalk(Long.parseLong(args[0]));
            }
        }
        if (rw != null) {
            rw.start();
        } else {
            System.out.println("Unable to start RandomWalk!!");
        }
    }
}

