/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.test;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import org.mbari.test.IPointListener;
import org.mbari.test.Point;
import org.mbari.test.RandomWalk;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.MathType;
import visad.Real;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.Text;
import visad.TextControl;
import visad.TextType;
import visad.Tuple;
import visad.TupleType;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class PointVis3
implements IPointListener {
    private RealType index;
    private RealType posX;
    private RealType posY;
    private TextType text;
    private RealTupleType xyTuple;
    private TupleType textTuple;
    private FunctionType indexFunc;
    private FunctionType xyFunc;
    private FunctionType textFunc;
    private Set indexSet;
    private Set indexSet0;
    private Set xySet;
    private FlatField pointsFf;
    private FlatField pointFf;
    private FieldImpl textF;
    private DataReferenceImpl pointsRef;
    private DataReferenceImpl pointRef;
    private DataReferenceImpl textRef;
    private DisplayImpl display;
    private ScalarMap xMap;
    private ScalarMap yMap;
    private ScalarMap xRangeMap;
    private ScalarMap textMap;
    private Point[] points;

    public PointVis3() throws VisADException, RemoteException {
        this(5);
    }

    public PointVis3(int trailLength) throws VisADException, RemoteException {
        this.points = new Point[trailLength];
        this.posX = new RealType("X");
        this.posY = new RealType("Y");
        this.index = new RealType("index");
        this.text = new TextType("Text");
        this.xyTuple = new RealTupleType(this.posX, this.posY);
        this.indexFunc = new FunctionType((MathType)this.index, (MathType)this.xyTuple);
        this.indexSet = new Integer1DSet((MathType)this.index, trailLength);
        this.pointsFf = new FlatField(this.indexFunc, this.indexSet);
        this.pointsFf.setSamples(this.getXY());
        this.indexSet0 = new Integer1DSet((MathType)this.index, 1);
        this.pointFf = new FlatField(this.indexFunc, this.indexSet0);
        this.pointFf.setSamples(this.getXY0());
        MathType[] mType = new MathType[]{this.posX, this.posY, this.text};
        this.textTuple = new TupleType(mType);
        this.textFunc = new FunctionType((MathType)this.index, (MathType)this.textTuple);
        this.textF = new FieldImpl(this.textFunc, this.indexSet0);
        String posString = "0, 0";
        Data[] textData = new Data[]{new Real(this.posX, 0.0), new Real(this.posY, 0.0), new Text(this.text, posString)};
        Tuple tt = new Tuple(this.textTuple, textData);
        this.textF.setSample(0, (Data)tt);
        this.display = new DisplayImplJ2D("display1");
        GraphicsModeControl dispGMC = this.display.getGraphicsModeControl();
        dispGMC.setScaleEnable(true);
        this.xMap = new ScalarMap((ScalarType)this.posX, Display.XAxis);
        this.yMap = new ScalarMap((ScalarType)this.posY, Display.YAxis);
        this.textMap = new ScalarMap((ScalarType)this.text, Display.Text);
        this.display.addMap(this.xMap);
        this.display.addMap(this.yMap);
        this.display.addMap(this.textMap);
        this.xMap.setRange(-20.0, 20.0);
        this.yMap.setRange(-20.0, 20.0);
        this.pointsRef = new DataReferenceImpl("pointsRef");
        this.pointRef = new DataReferenceImpl("pointRef");
        this.textRef = new DataReferenceImpl("textRef");
        this.pointsRef.setData((Data)this.pointsFf);
        this.pointRef.setData((Data)this.pointFf);
        this.textRef.setData((Data)this.textF);
        ConstantMap[] pointsCMap = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(2.0, Display.PointSize)};
        ConstantMap[] pointCMap = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap((double)0.8f, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(5.0, Display.PointSize)};
        ConstantMap[] textCMap = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap((double)0.8f, Display.Green), new ConstantMap(0.0, Display.Blue)};
        this.display.addReference((DataReference)this.pointRef, pointCMap);
        this.display.addReference((DataReference)this.pointsRef, pointsCMap);
        this.display.addReference((DataReference)this.textRef, textCMap);
        JFrame frame = new JFrame("VisAD " + this);
        frame.getContentPane().add(this.display.getComponent());
        frame.setSize(300, 300);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        TextControl textControl = (TextControl)this.textMap.getControl();
        textControl.setSize(0.75);
        textControl.setJustification(TextControl.Justification.RIGHT);
        textControl.setRotation(0.0);
        textControl.setAutoSize(true);
    }

    public void update(Point point) throws RemoteException {
        for (int i = this.points.length - 1; i > 0; --i) {
            this.points[i] = this.points[i - 1];
        }
        this.points[0] = (Point)point.clone();
        try {
            this.pointsFf.setSamples(this.getXY());
            this.pointFf.setSamples(this.getXY0());
            String posString = this.points[0].getX() + ", " + this.points[0].getY();
            Data[] textData = new Data[]{new Real(this.posX, this.points[0].getX()), new Real(this.posY, this.points[0].getY()), new Text(this.text, posString)};
            Tuple tt = new Tuple(this.textTuple, textData);
            this.textF.setSample(0, (Data)tt);
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
    }

    private float[][] getXY() {
        float[][] tmp = new float[2][this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i] != null) {
                tmp[0][i] = (float)this.points[i].getX();
                tmp[1][i] = (float)this.points[i].getY();
                continue;
            }
            tmp[0][i] = 0.0f;
            tmp[1][i] = 0.0f;
        }
        return tmp;
    }

    private float[][] getXY0() {
        float[][] tmp = new float[2][1];
        if (this.points[0] != null) {
            tmp[0][0] = (float)this.points[0].getX();
            tmp[1][0] = (float)this.points[0].getY();
        } else {
            tmp[0][0] = 0.0f;
            tmp[1][0] = 0.0f;
        }
        return tmp;
    }

    public static void main(String[] args) {
        try {
            RandomWalk rw = null;
            rw = args.length == 0 ? new RandomWalk() : new RandomWalk(Long.parseLong(args[0]));
            PointVis3 pv = null;
            pv = args.length < 2 ? new PointVis3() : new PointVis3(Integer.parseInt(args[1]));
            rw.addPointListener(pv);
            rw.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

