/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.test;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import org.mbari.test.IPointListener;
import org.mbari.test.Point;
import org.mbari.test.RandomWalk;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.MathType;
import visad.RangeControl;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class PointVis
implements IPointListener {
    private RealType index;
    private RealType posX;
    private RealType posY;
    private RealTupleType xyTuple;
    private FunctionType indexFunc;
    private FunctionType xyFunc;
    private Set indexSet;
    private Set xySet;
    private FlatField lineFf;
    private FlatField pointsFf;
    private DataReferenceImpl lineRef;
    private DataReferenceImpl pointsRef;
    private DisplayImpl display;
    private ScalarMap xMap;
    private ScalarMap yMap;
    private ScalarMap xRangeMap;
    private Point[] points;

    public PointVis() throws VisADException, RemoteException {
        this(5);
    }

    public PointVis(int trailLength) throws VisADException, RemoteException {
        this.points = new Point[trailLength];
        this.posX = new RealType("X");
        this.posY = new RealType("Y");
        this.index = new RealType("index");
        this.xyTuple = new RealTupleType(this.posX, this.posY);
        this.indexFunc = new FunctionType((MathType)this.index, (MathType)this.xyTuple);
        this.indexSet = new Integer1DSet((MathType)this.index, trailLength);
        this.pointsFf = new FlatField(this.indexFunc, this.indexSet);
        this.pointsFf.setSamples(this.getXY());
        this.xyFunc = new FunctionType((MathType)this.posX, (MathType)this.posY);
        this.display = new DisplayImplJ2D("display1");
        GraphicsModeControl dispGMC = this.display.getGraphicsModeControl();
        dispGMC.setScaleEnable(true);
        this.xMap = new ScalarMap((ScalarType)this.posX, Display.XAxis);
        this.yMap = new ScalarMap((ScalarType)this.posY, Display.YAxis);
        this.xRangeMap = new ScalarMap((ScalarType)this.posX, Display.SelectRange);
        this.display.addMap(this.xMap);
        this.display.addMap(this.yMap);
        this.display.addMap(this.xRangeMap);
        this.xMap.setRange(-20.0, 20.0);
        this.yMap.setRange(-20.0, 20.0);
        RangeControl xRangeControl = (RangeControl)this.xRangeMap.getControl();
        float[] xRange = new float[]{-20.0f, 20.0f};
        xRangeControl.setRange(xRange);
        this.pointsRef = new DataReferenceImpl("pointsRef");
        this.pointsRef.setData((Data)this.pointsFf);
        ConstantMap[] pointsCMap = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(4.5, Display.PointSize)};
        ConstantMap[] lineCMap = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap((double)0.8f, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(1.5, Display.LineWidth)};
        this.display.addReference((DataReference)this.pointsRef, pointsCMap);
        JFrame frame = new JFrame("VisAD " + this);
        frame.getContentPane().add(this.display.getComponent());
        frame.setSize(300, 300);
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public void update(Point point) throws RemoteException {
        for (int i = this.points.length - 1; i > 0; --i) {
            this.points[i] = this.points[i - 1];
        }
        this.points[0] = (Point)point.clone();
        try {
            this.pointsFf.setSamples(this.getXY());
        }
        catch (VisADException e) {
            e.printStackTrace();
        }
    }

    private float[][] getXY() {
        float[][] tmp = new float[2][this.points.length];
        for (int i = 0; i < this.points.length; ++i) {
            if (this.points[i] != null) {
                tmp[0][i] = (float)this.points[i].getX();
                tmp[1][i] = (float)this.points[i].getY();
                continue;
            }
            tmp[0][i] = 0.0f;
            tmp[1][i] = 0.0f;
        }
        return tmp;
    }

    private float[][] getXY0() {
        float[][] tmp = new float[2][1];
        if (this.points[0] != null) {
            tmp[0][0] = (float)this.points[0].getX();
            tmp[1][0] = (float)this.points[0].getY();
        } else {
            tmp[0][0] = 0.0f;
            tmp[1][0] = 0.0f;
        }
        return tmp;
    }

    public static void main(String[] args) {
        try {
            RandomWalk rw = null;
            rw = args.length == 0 ? new RandomWalk() : new RandomWalk(Long.parseLong(args[0]));
            PointVis pv = new PointVis();
            rw.addPointListener(pv);
            rw.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }
}

