/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing.tree;

import java.io.File;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class FileSystemNode
extends DefaultMutableTreeNode {
    boolean explored = false;

    public FileSystemNode(File file) {
        this.setUserObject(file);
    }

    public boolean getAllowsChildren() {
        return this.isDirectory();
    }

    public boolean isLeaf() {
        return !this.isDirectory();
    }

    public File getFile() {
        return (File)this.getUserObject();
    }

    public boolean isExplored() {
        return this.explored;
    }

    public boolean isDirectory() {
        File file = this.getFile();
        return file.isDirectory();
    }

    public String toString() {
        File file = this.getFile();
        String name = file.getName();
        if (name.equals("")) {
            name = file.getAbsolutePath();
        }
        return name;
    }

    public abstract void explore();
}

