/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.swing;

import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.mbari.swing.tree.DirNode;
import org.mbari.util.FileUtil;

public class DirectoryTree1
extends JTree {
    public DirectoryTree1() {
        super(DirectoryTree1.getDefaultTreeModel());
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.listen();
    }

    protected static TreeModel getDefaultTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Root Directories");
        File[] roots = FileUtil.getDirRoots();
        for (int i = 0; i < roots.length; ++i) {
            root.add(new DirNode(roots[i]));
        }
        return new DefaultTreeModel(root);
    }

    protected void listen() {
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent e) {
            }

            public void treeExpanded(TreeExpansionEvent e) {
                TreePath path = e.getPath();
                DirNode node = (DirNode)path.getLastPathComponent();
                DefaultTreeModel model = null;
                if (!node.isExplored() && (model = (DefaultTreeModel)DirectoryTree1.this.getModel()) != null) {
                    node.explore();
                    model.nodeStructureChanged(node);
                }
            }
        });
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("DirectoryTree1 test");
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        DirectoryTree1 tree = new DirectoryTree1();
        Container p = f.getContentPane();
        f.getContentPane().add(tree);
        f.setSize(300, 300);
        f.pack();
        f.setVisible(true);
        f.show();
    }
}

