/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import org.mbari.io.OasisPco2Reader;
import org.mbari.oasis.Pco2FileFormat;
import org.mbari.util.StringUtil;
import org.mbari.util.TimeUtil;

public class Pco2Reader {
    private File file;
    private HashMap hm;
    private String type;
    private Pco2FileFormat format;

    public Pco2Reader(File file) throws IOException {
        this(file, new Pco2FileFormat(1));
    }

    public Pco2Reader(String file) throws IOException {
        this(new File(file), new Pco2FileFormat(1));
    }

    public Pco2Reader(File file, int format) throws IOException {
        this(file, new Pco2FileFormat(format));
    }

    public Pco2Reader(String file, int format) throws IOException {
        this(new File(file), format);
    }

    public Pco2Reader(File file, Pco2FileFormat format) throws IOException {
        this.file = file;
        this.format = format;
        this.read();
    }

    public Pco2Reader(String file, Pco2FileFormat format) throws IOException {
        this(new File(file), format);
    }

    public double[] get(String key) throws IllegalArgumentException {
        if (!this.hm.containsKey(key = key.toLowerCase())) {
            throw new IllegalArgumentException("The specified type was not found");
        }
        ArrayList a = (ArrayList)this.hm.get(key);
        Object[] o = a.toArray();
        double[] data = new double[o.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (Double)o[i];
        }
        return data;
    }

    public double[] getTime() throws IllegalArgumentException {
        String key = "time_d";
        return this.get(key);
    }

    public double[] getTime(String type) throws IllegalArgumentException {
        String key = "time_" + type;
        return this.get(key);
    }

    public double[] getPco2() throws IllegalArgumentException {
        String key = "pco2_d";
        return this.get(key);
    }

    public double[] getPco2(String type) throws IllegalArgumentException {
        String key = "pco2" + type;
        return this.get(key);
    }

    public Set getTypes() {
        return this.hm.keySet();
    }

    public Pco2FileFormat getFormat() {
        return this.format;
    }

    private void read() throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        this.hm = new HashMap();
        while ((line = in.readLine()) != null) {
            String keyTime;
            StringTokenizer st;
            int NumOfCol;
            if (line.startsWith("#") || line.startsWith("%") || (NumOfCol = (st = new StringTokenizer(line)).countTokens()) < this.format.getMinNumColumns() || NumOfCol > this.format.getMaxNumColumns()) continue;
            String key = StringUtil.getToken(line, this.format.getMinNumColumns());
            if (key.length() > 1) {
                key = "D";
            }
            if (!this.hm.containsKey(keyTime = "time_" + key.toLowerCase())) {
                this.hm.put(keyTime, new ArrayList());
            }
            double dayOfYear = new Double(st.nextToken());
            double year = new Double(StringUtil.getToken(line, NumOfCol));
            Double time = new Double(TimeUtil.dayOfYearToDate(dayOfYear, year).getTime());
            ArrayList a = (ArrayList)this.hm.get(keyTime);
            a.add(time);
            for (int i = 0; i < this.format.getColumnNames().length; ++i) {
                Double tempVar;
                String[] columns = this.format.getColumnNames();
                String tempKey = columns[i] + "_" + key.toLowerCase();
                if (!this.hm.containsKey(tempKey)) {
                    this.hm.put(tempKey, new ArrayList());
                }
                try {
                    tempVar = new Double(st.nextToken());
                }
                catch (NumberFormatException e) {
                    tempVar = new Double(Double.NaN);
                }
                a = (ArrayList)this.hm.get(tempKey);
                a.add(tempVar);
            }
        }
    }

    public static void test() {
        try {
            OasisPco2Reader r = new OasisPco2Reader("g:/m1/data/pco2");
            Set set = r.getTypes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }
}

