/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.mbari.io.OasisPco2Reader;
import org.mbari.util.MathUtil;
import ucar.ma2.ArrayAbstract;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class OasisPco2Netcdf {
    private OasisPco2Reader infile;
    private File outfile;
    private File calfile;
    private String mooring;
    private static final String[] TYPES = new String[]{"d", "i", "c"};
    private static final String[] POSTFIX = new String[]{"", " of intermediate pressure samples", " of calibration samples"};
    private static final String[] PREFIX = new String[]{"", "Intermediate pressure ", "Calibration"};

    public OasisPco2Netcdf(String mooring, String infile, String calfile, String outfile) throws IOException {
        this(mooring, new File(infile), new File(calfile), new File(outfile));
    }

    public OasisPco2Netcdf(String mooring, File infile, File calfile, File outfile) throws IOException {
        this.mooring = mooring;
        this.infile = new OasisPco2Reader(infile);
        this.calfile = calfile;
        this.outfile = outfile;
        this.makeNetcdf();
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.out.println("\nUsage: org.mbari.oasis.OasisPco2Netcdf <mooring> <input file> <properties file>  <output file>");
            System.exit(0);
        }
        try {
            OasisPco2Netcdf oasisPco2Netcdf1 = new OasisPco2Netcdf(args[0], args[1], args[2], args[3]);
        }
        catch (IOException e) {
            System.out.println(" Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private void makeNetcdf() throws IOException {
        String varName;
        int j;
        int[] order;
        int i;
        Properties mooringProperties = new Properties();
        BufferedInputStream mooringPropertiesStream = new BufferedInputStream(new FileInputStream(this.calfile));
        mooringProperties.load(mooringPropertiesStream);
        mooringPropertiesStream.close();
        float[] lat = new float[]{Float.parseFloat(mooringProperties.getProperty(this.mooring + ".latitude", "-999"))};
        float[] lon = new float[]{Float.parseFloat(mooringProperties.getProperty(this.mooring + ".longitude", "-999"))};
        float[] depth = new float[]{Float.parseFloat(mooringProperties.getProperty(this.mooring + ".waterdepth", "-999"))};
        NetcdfFileWriteable ncfile = new NetcdfFileWriteable();
        ncfile.setName(this.outfile.getCanonicalPath());
        ncfile.addGlobalAttribute("conventions", "MBARI/timeSeries/mooring/pco2");
        ncfile.addGlobalAttribute("creationDate", new Date().toString());
        ncfile.addGlobalAttribute("lastModified", new Date().toString());
        ncfile.addGlobalAttribute("mooring", this.mooring.toUpperCase());
        ncfile.addGlobalAttribute("description", "pCO2 data");
        ncfile.addGlobalAttribute("waterdepth", (Object)depth);
        ncfile.addGlobalAttribute("keywords", "pCO2, mooring");
        ncfile.addGlobalAttribute("instrumentType", "pCO2 Can");
        Dimension latDim = ncfile.addDimension("latitude", 1);
        Dimension lonDim = ncfile.addDimension("longitude", 1);
        ncfile.addVariable("latitude", Float.TYPE, new Dimension[]{latDim});
        ncfile.addVariableAttribute("latitude", "long_name", "Latitude");
        ncfile.addVariableAttribute("latitude", "units", "degrees_north (+N/-S)");
        ncfile.addVariable("longitude", Float.TYPE, new Dimension[]{lonDim});
        ncfile.addVariableAttribute("longitude", "long_name", "Longitude");
        ncfile.addVariableAttribute("longitude", "units", "degrees_east (+E/-W)");
        for (i = 0; i < TYPES.length; ++i) {
            double[] time;
            try {
                time = this.infile.getTime(TYPES[i]);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            order = MathUtil.uniqueSort(time);
            String timeName = "time_" + TYPES[i].toLowerCase();
            Dimension timeDim = ncfile.addDimension(timeName, order.length);
            Dimension[] dim3 = new Dimension[]{timeDim, latDim, lonDim};
            System.out.println("Adding: " + timeName);
            ncfile.addVariable(timeName, Double.TYPE, new Dimension[]{timeDim});
            ncfile.addVariableAttribute(timeName, "long_name", "time GMT" + POSTFIX[i]);
            ncfile.addVariableAttribute(timeName, "units", "seconds since 01 Jan 1970 00:00:00 GMT");
            if (TYPES[i].equalsIgnoreCase("d")) {
                String varName2 = "pco2";
                System.out.println("Adding: " + varName2);
                ncfile.addVariable(varName2, Float.TYPE, dim3);
                ncfile.addVariableAttribute(varName2, "long_name", "calibrated pCO2");
                ncfile.addVariableAttribute(varName2, "units", "parts per million");
                ncfile.addVariableAttribute(varName2, "_FillValue", (Number)new Float(Float.NaN));
                ncfile.addVariableAttribute(varName2, "missing_value", (Number)new Float(Float.NaN));
                varName2 = "int_pco2_c";
                System.out.println("Adding: " + varName2);
                ncfile.addVariable(varName2, Float.TYPE, dim3);
                ncfile.addVariableAttribute(varName2, "long_name", "pCO2 of calibration samples interpolated to raw sample times");
                ncfile.addVariableAttribute(varName2, "units", "parts per million");
                ncfile.addVariableAttribute(varName2, "_FillValue", (Number)new Float(Float.NaN));
                ncfile.addVariableAttribute(varName2, "missing_value", (Number)new Float(Float.NaN));
            }
            for (j = 0; j < OasisPco2Reader.COLUMNS.length; ++j) {
                varName = OasisPco2Reader.COLUMNS[j] + "_" + TYPES[i].toLowerCase();
                System.out.println("Adding: " + varName);
                ncfile.addVariable(varName, Float.TYPE, dim3);
                ncfile.addVariableAttribute(varName, "long_name", OasisPco2Reader.LONG_NAME[j] + POSTFIX[i]);
                ncfile.addVariableAttribute(varName, "units", OasisPco2Reader.UNITS[j]);
                ncfile.addVariableAttribute(varName, "_FillValue", (Number)new Float(Float.NaN));
                ncfile.addVariableAttribute(varName, "missing_value", (Number)new Float(Float.NaN));
            }
        }
        ncfile.create();
        ncfile.write("latitude", ArrayAbstract.factory((Object)lat));
        ncfile.write("longitude", ArrayAbstract.factory((Object)lon));
        for (i = 0; i < TYPES.length; ++i) {
            double[] timeRaw;
            try {
                timeRaw = this.infile.getTime(TYPES[i]);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            order = MathUtil.uniqueSort(timeRaw);
            double[] timeSorted = MathUtil.orderVector(timeRaw, order);
            double[] timeSec = new double[timeSorted.length];
            for (int j2 = 0; j2 < timeSorted.length; ++j2) {
                timeSec[j2] = timeSorted[j2] / 1000.0;
            }
            String timeName = "time_" + TYPES[i].toLowerCase();
            System.out.println("Writing: " + timeName);
            ncfile.write(timeName, ArrayAbstract.factory((Object)timeSec));
            if (TYPES[i].equalsIgnoreCase("d")) {
                double[] timeCal = this.infile.get("time_c");
                int[] orderCal = MathUtil.uniqueSort(timeCal);
                double[] timeCalSorted = MathUtil.orderVector(timeCal, orderCal);
                double[] pco2DataSorted = MathUtil.orderVector(this.infile.get("pco2_d"), order);
                double[] calDataSorted = MathUtil.orderVector(this.infile.get("pco2_c"), orderCal);
                double[] calDataInterp = MathUtil.interpLinear(timeCalSorted, calDataSorted, timeSorted);
                float[][][] pco2 = new float[timeSec.length][1][1];
                float[][][] calI = new float[timeSec.length][1][1];
                for (int k = 0; k < timeSec.length; ++k) {
                    calI[k][0][0] = (float)calDataInterp[k];
                    pco2[k][0][0] = (float)(pco2DataSorted[k] - calDataInterp[k]);
                }
                ncfile.write("pco2", ArrayAbstract.factory((Object)pco2));
                ncfile.write("int_pco2_c", ArrayAbstract.factory((Object)calI));
            }
            for (j = 0; j < OasisPco2Reader.COLUMNS.length; ++j) {
                varName = OasisPco2Reader.COLUMNS[j] + "_" + TYPES[i];
                System.out.println("Writing: " + varName);
                double[] dataSorted = MathUtil.orderVector(this.infile.get(varName), order);
                float[][][] data = new float[order.length][1][1];
                for (int k = 0; k < order.length; ++k) {
                    data[k][0][0] = (float)dataSorted[k];
                }
                ncfile.write(varName.toLowerCase(), ArrayAbstract.factory((Object)data));
            }
        }
        ncfile.close();
    }
}

