/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.mbari.hobilabs.HS2CalibrationFileReader;
import org.mbari.oasis.OasisHS2Parser;

public class OasisHS2Processer {
    File[] files;
    Properties cal;
    String dst;

    public OasisHS2Processer(String src, String calFile, String destFile) {
        this.dst = destFile;
        try {
            this.cal = new HS2CalibrationFileReader(calFile).getProperties();
            File fid = new File(src);
            if (fid.isDirectory()) {
                String[] fileList = fid.list();
                Arrays.sort(fileList, String.CASE_INSENSITIVE_ORDER);
                this.files = new File[fileList.length];
                for (int i = 0; i < fileList.length; ++i) {
                    this.files[i] = new File(fid, fileList[i]);
                }
            } else {
                this.files = new File[1];
                this.files[0] = fid;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void process() {
        try {
            int i;
            BufferedWriter bos = new BufferedWriter(new FileWriter(this.dst));
            bos.write("# File created on " + new Date() + "\n");
            bos.write("#");
            bos.write(" HS2 Data Header\n#\n# The overall format is:\n");
            bos.write("# Note: The data may not contain all the columns specified in this header.\n# However, the data is always stored in the order thats specified in \n# the header. If only four columns of data are present then use the \n# first four column titles listed below.\n");
            bos.write("#\n# time");
            for (i = 1; i < 9; ++i) {
                String name = this.cal.getProperty("Channel" + i + ".Name");
                if (name == null || name.equalsIgnoreCase("null")) continue;
                bos.write(" " + name);
            }
            bos.write("\n#\n# Time = epic seconds (seconds since Jan 01, 1970 00:00:00)\n");
            bos.write("# Missing_value = -999\n");
            for (i = 0; i < this.files.length; ++i) {
                OasisHS2Parser oasisHS2Parser = new OasisHS2Parser(this.files[i], bos, this.cal);
            }
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println("Usage: OasisHS2Proscesser <input directory or file> <calibration file> <output file>");
            System.exit(0);
        }
        OasisHS2Processer op = new OasisHS2Processer(args[0], args[1], args[2]);
        op.process();
    }
}

