/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mbari.hobilabs.HSDPacket;
import org.mbari.hobilabs.HSDParser;

public class OasisHS2Parser {
    private File inFile;
    private Writer out;
    private Properties cal;
    private NumberFormat nf = NumberFormat.getNumberInstance();
    private static final Log log = LogFactory.getLog((Class)(class$org$mbari$oasis$OasisHS2Parser == null ? (class$org$mbari$oasis$OasisHS2Parser = OasisHS2Parser.class$("org.mbari.oasis.OasisHS2Parser")) : class$org$mbari$oasis$OasisHS2Parser));
    static /* synthetic */ Class class$org$mbari$oasis$OasisHS2Parser;

    public OasisHS2Parser(File inFile_, Writer out_, Properties cal_) {
        this.inFile = inFile_;
        this.out = out_;
        this.cal = cal_;
        log.debug((Object)("Using the following files:\n\tInput = " + this.inFile + "\n\tOutput = " + this.out + "\n\tCalibration = " + cal_));
        this.nf.setMaximumFractionDigits(8);
        this.nf.setMinimumFractionDigits(8);
        this.nf.setMinimumIntegerDigits(1);
        this.parse();
    }

    private void parse() {
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(this.inFile));
            while ((s = in.readLine()) != null) {
                if (!s.startsWith("*D")) continue;
                try {
                    HSDPacket p = HSDParser.parse(s);
                    this.calibrate(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Invalid string");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void calibrate(HSDPacket p) throws IOException {
        boolean newLine = true;
        for (int i = 0; i < 8; ++i) {
            if (p.getGain(i) == 0) continue;
            int j = i + 1;
            double T = (double)p.getTemperature() / 5.0 - 10.0;
            double bb = Double.NaN;
            try {
                double Tc = this.getValue("Channel" + j + ".TempCoeff");
                double Tn = this.getValue("TempNom");
                double mu = this.getValue("Channel" + j + ".Mu");
                double beta = this.getValue("Channel" + j + ".Beta2Bb");
                double gain = this.getValue("Channel" + j + ".Gain" + p.getGain(i));
                double Rn = this.getValue("Channel" + j + ".RNominal");
                double bbu = (1.0 - Tc * T / Tn) * mu * beta * (double)p.getSnorm(i) / (gain * Rn);
                double B = this.getValue("Channel" + j + ".Bb2c");
                double c = bbu * B;
                double sigma1 = this.getValue("Channel" + j + ".Sigma1");
                double sigma2 = this.getValue("Channel" + j + ".Sigma2");
                double sigma3 = this.getValue("Channel" + j + ".Sigma3");
                double sigmaC = sigma1 + sigma2 * c + sigma3 * Math.pow(c, 2.0);
                bb = bbu * sigmaC;
            }
            catch (Throwable t) {
                log.error((Object)"Failed to get calibration info", t);
                continue;
            }
            if (newLine) {
                this.out.write(p.getTime() / 1000L + "");
                newLine = false;
            }
            this.out.write("\t" + this.nf.format(bb));
        }
        this.out.write("\n");
    }

    private double getValue(String propertyName) throws Throwable {
        double value = 0.0;
        try {
            value = Double.parseDouble(this.cal.getProperty(propertyName));
        }
        catch (Exception e) {
            log.error((Object)("Unable to retrieve calibration property '" + propertyName + "'"), (Throwable)e);
            throw e;
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

