/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.Collator;
import java.util.Locale;

public class OasisFileCoallator {
    private OasisFileCoallator() {
    }

    public static final synchronized void coallate(File outFile, File inPath) throws IOException {
        Locale locale = Locale.US;
        Collator collator = Collator.getInstance(locale);
        String[] fileList = inPath.list();
        fileList = OasisFileCoallator.sortFiles(collator, fileList);
        BufferedWriter out = new BufferedWriter(new FileWriter(outFile));
        for (int i = 0; i < fileList.length; ++i) {
            String line;
            File file = new File(inPath, fileList[i]);
            System.out.println(inPath + System.getProperty("file.separator") + fileList[i]);
            BufferedReader in = new BufferedReader(new FileReader(file));
            int Year = OasisFileCoallator.getYear(fileList[i]);
            while ((line = in.readLine()) != null) {
                if (i != 0 & line.startsWith("#")) continue;
                if (i == 0 & line.startsWith("#")) {
                    out.write(line);
                    out.newLine();
                    continue;
                }
                out.write(line);
                out.write(" ");
                out.write(Integer.toString(Year));
                out.newLine();
            }
            out.flush();
            in.close();
        }
        out.close();
    }

    public static final void coallate(File out) throws IOException {
        File in = new File(System.getProperty("user.dir"));
        OasisFileCoallator.coallate(out, in);
    }

    public static final void coallate(String outfile) throws IOException {
        File out = new File(outfile);
        File in = new File(System.getProperty("user.dir"));
        OasisFileCoallator.coallate(out, in);
    }

    public static final void coallate(String outfile, String inFilepath) throws IOException {
        File out = new File(outfile);
        File in = new File(inFilepath);
        OasisFileCoallator.coallate(out, in);
    }

    public static int getYear(String file) {
        if (file.length() == 5) {
            char[] buf = new char[2];
            file.getChars(0, 2, buf, 0);
            String Year = new String(buf);
            return Integer.parseInt(Year) + 1900;
        }
        if (file.length() == 7) {
            char[] buf = new char[4];
            file.getChars(0, 4, buf, 0);
            String Year = new String(buf);
            return Integer.parseInt(Year);
        }
        return 0;
    }

    public static String[] sortFiles(Collator collator, String[] strArray) {
        for (int i = 0; i < strArray.length; ++i) {
            for (int j = i + 1; j < strArray.length; ++j) {
                if (collator.compare(strArray[i], strArray[j]) <= 0) continue;
                String tmp = strArray[i];
                strArray[i] = strArray[j];
                strArray[j] = tmp;
            }
        }
        return strArray;
    }

    public static void main(String[] args) {
        if (args.length == 0 || args.length > 2) {
            System.out.println("Usage: java org.mbari.oasis.OasisFileCoallator OutFile <InFilePath>");
            System.out.println("Inputs: ");
            System.out.println("   OutFile    = name of the file to write output to");
            System.out.println("   InFilePath = Optional argument. Specifies directory");
            System.out.println("                containing source data files");
            System.out.println(" ");
            System.out.println("Note: InFilePath should only contain data files");
            System.exit(0);
        } else if (args.length == 1) {
            try {
                OasisFileCoallator.coallate(args[0]);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else if (args.length == 2) {
            try {
                OasisFileCoallator.coallate(args[0], args[1]);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
    }
}

