/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import org.mbari.io.FlatFileReader;

public class OasisFileChecker {
    File file;
    double[] dates;
    boolean OK = true;

    OasisFileChecker(File f) throws IOException {
        this.file = f;
        this.init();
        this.process();
    }

    OasisFileChecker(String f) throws IOException {
        this.file = new File(f);
        this.init();
        this.process();
    }

    private void init() throws IOException {
        FlatFileReader ffr = new FlatFileReader(this.file);
        ffr.readFile();
        this.dates = new double[ffr.countRows()];
        for (int i = 0; i < this.dates.length; ++i) {
            this.dates[i] = ffr.getData(i, 0);
        }
        this.process();
    }

    private void process() {
        int i = this.checkDate();
        if (!this.OK) {
            try {
                this.rewrite(i);
            }
            catch (IOException e) {
                System.out.println("Unable to process " + this.file.getName());
            }
        }
    }

    private int checkDate() {
        int i;
        double min = this.dates[0];
        for (i = 1; i < this.dates.length; ++i) {
            if (min != this.dates[i]) continue;
            this.OK = false;
            break;
        }
        return i;
    }

    private void rewrite(int i) throws IOException {
        String line;
        System.out.println("OasisFileChecker: rewriting " + this.file);
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        Vector<String> text = new Vector<String>(i);
        int lineCount = -1;
        int dataCount = 0;
        while ((line = in.readLine()) != null) {
            ++lineCount;
            if (line.startsWith("#") || line.startsWith("%")) {
                text.add(lineCount, line);
                continue;
            }
            if (dataCount >= i) continue;
            ++dataCount;
            text.add(lineCount, line);
        }
        in.close();
        BufferedWriter out = new BufferedWriter(new FileWriter(this.file));
        for (int j = 0; j < text.size(); ++j) {
            out.write((String)text.elementAt(j));
            out.newLine();
        }
        out.close();
    }

    public static void main(String[] args) {
        File f;
        if (args.length > 1 || args.length < 1) {
            System.out.println("Usage: OasisFileChecker filename/directory");
            System.exit(0);
        }
        if ((f = new File(args[0])).isDirectory()) {
            String[] list = f.list();
            for (int i = 0; i < list.length; ++i) {
                try {
                    OasisFileChecker oasisFileChecker = new OasisFileChecker(new File(f, list[i]));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else {
            try {
                OasisFileChecker oasisFileChecker = new OasisFileChecker(f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.exit(1);
    }
}

