/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.Collator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import org.mbari.oasis.OMSAbstractSchemaConstructor;
import org.mbari.oasis.OMSConfigReader;
import org.mbari.oasis.OMSSensor;
import org.mbari.oasis.OMSUtil;

public class OMSSchemaConstructor
extends OMSAbstractSchemaConstructor {
    public OMSSchemaConstructor(String fileS) {
        super(new File(fileS));
    }

    public OMSSchemaConstructor(File file) {
        super(file);
    }

    protected OMSSensor[] getSensors() {
        Hashtable<String, OMSSensor> table = new Hashtable<String, OMSSensor>(151, 0.6f);
        try {
            String str;
            OMSConfigReader cr = new OMSConfigReader(this.cfgfile);
            OMSSensor[] s = cr.getConfiguration();
            for (int i = 0; i < s.length; ++i) {
                table.put(OMSUtil.getUniqueName(s[i]), s[i]);
            }
            BufferedReader in = new BufferedReader(new FileReader(this.cfgfile));
            while ((str = in.readLine()) != null) {
                StringTokenizer st;
                if (!str.startsWith("9") && !str.startsWith("1") && !str.startsWith("2") || (st = new StringTokenizer(str)).countTokens() <= 4) continue;
                double d1 = Double.parseDouble(st.nextToken());
                String buf = st.nextToken();
                double d2 = Double.parseDouble(st.nextToken());
                String type = st.nextToken();
                if (!type.startsWith("specprr")) continue;
                cr = new OMSConfigReader(this.cfgfile, d1);
                s = cr.getConfiguration();
                for (int i = 0; i < s.length; ++i) {
                    Object v = table.get(OMSUtil.getUniqueName(s[i]));
                    if (v != null) continue;
                    table.put(OMSUtil.getUniqueName(s[i]), s[i]);
                }
            }
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        OMSSensor[] sensor = new OMSSensor[table.size()];
        Enumeration elements = table.elements();
        int i = 0;
        while (elements.hasMoreElements()) {
            sensor[i] = (OMSSensor)elements.nextElement();
            ++i;
        }
        sensor = this.sortFiles(sensor);
        return sensor;
    }

    public OMSSensor[] sortFiles(OMSSensor[] s) {
        Locale locale = Locale.US;
        Collator collator = Collator.getInstance(locale);
        for (int i = 0; i < s.length; ++i) {
            for (int j = i + 1; j < s.length; ++j) {
                if (collator.compare(OMSUtil.getSortableName(s[i]), OMSUtil.getSortableName(s[j])) <= 0) continue;
                OMSSensor tmp = s[i];
                s[i] = s[j];
                s[j] = tmp;
            }
        }
        return s;
    }
}

