/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mbari.oasis.OMSNetcdfAppender;
import org.mbari.oasis.OMSSchemaConstructor;
import org.mbari.oasis.OMSUtil;
import org.mbari.oasis.OMSVariable;
import org.mbari.oasis.OMSVariableReader;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Schema;
import ucar.netcdf.Variable;

public class OMSMain {
    private File cfg;
    private File dat;
    private File nc;
    private NetcdfFile netcdf;
    private static final Log log = LogFactory.getLog((Class)(class$org$mbari$oasis$OMSMain == null ? (class$org$mbari$oasis$OMSMain = OMSMain.class$("org.mbari.oasis.OMSMain")) : class$org$mbari$oasis$OMSMain));
    static /* synthetic */ Class class$org$mbari$oasis$OMSMain;

    private OMSMain(File cfg, File dat, File nc) throws IOException {
        this.cfg = cfg;
        this.dat = dat;
        this.nc = nc;
        if (nc.exists()) {
            this.netcdf = new NetcdfFile(nc, false);
        } else {
            this.netcdf = new NetcdfFile(nc, true, true, this.getSchema());
            this.addAxes();
        }
        this.addData();
        this.netcdf.close();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println();
            System.out.println("Usage: org.mbari.netcdf.OMSNetcdf configfile datafile ncfile");
            System.out.println();
            System.out.println("Inputs: configfile = name of the mooring configuration file");
            System.out.println("        datafile   = name of specprr data directory");
            System.out.println("        ncfile     = name of netcdf file to be created");
            System.out.println();
            System.exit(0);
        }
        try {
            boolean OK = true;
            File cfg = new File(args[0]);
            if (!cfg.exists()) {
                log.warn((Object)("The configuration file, " + args[0] + ", was not found."));
                OK = false;
            } else if (!cfg.canRead()) {
                log.warn((Object)("Unable to read the configuration file, " + args[0] + "."));
                OK = false;
            }
            File dat = new File(args[1]);
            if (!dat.exists()) {
                log.warn((Object)("The data directory, " + args[1] + ", was not found."));
                OK = false;
            } else if (!dat.canRead()) {
                log.warn((Object)("Unable to read the data directory, " + args[1] + "."));
                OK = false;
            }
            File nc = new File(args[2]);
            if (OK) {
                OMSMain main = new OMSMain(cfg, dat, nc);
            } else {
                log.warn((Object)"The processing was aborted.");
            }
        }
        catch (IOException e) {
            log.fatal((Object)"Unable to read or create one of the input files", (Throwable)e);
        }
    }

    private void addAxes() throws IOException {
        OMSVariableReader vr = new OMSVariableReader(this.cfg);
        while (vr.hasMoreElements()) {
            OMSVariable v = (OMSVariable)vr.nextElement();
            float[] values = v.getValues();
            Variable vnc = this.netcdf.get(v.getName());
            for (int i = 0; i < values.length; ++i) {
                int[] index = new int[]{i};
                vnc.setDouble(index, (double)values[i]);
            }
        }
    }

    private void addData() throws IOException {
        String[] fileList = this.dat.list();
        fileList = OMSUtil.sortFiles(fileList);
        for (int i = 0; i < fileList.length; ++i) {
            OMSNetcdfAppender oMSNetcdfAppender = new OMSNetcdfAppender(this.cfg.getCanonicalPath(), new File(this.dat.getCanonicalPath(), fileList[i]).getCanonicalPath(), this.nc.getCanonicalPath());
        }
    }

    private Schema getSchema() throws IOException {
        System.out.println("Creating Schema from " + this.cfg);
        OMSSchemaConstructor sc = new OMSSchemaConstructor(this.cfg);
        return sc.getSchema();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

