/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import java.util.StringTokenizer;
import org.mbari.hobilabs.HRBinaryDecoder;
import org.mbari.hobilabs.HRCalFileNameFilter;
import org.mbari.hobilabs.HRCalibrationFileReader;
import org.mbari.hobilabs.HRPacket;
import org.mbari.util.GmtCalendar;
import org.mbari.util.HRUtil;
import ucar.multiarray.ArrayMultiArray;
import ucar.multiarray.MultiArray;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Schema;
import ucar.netcdf.UnlimitedDimension;
import ucar.netcdf.Variable;

public class HRNetcdfConstructor {
    File calDirectory;
    File[] infile;
    String outfile;
    String mooring;

    public HRNetcdfConstructor(String mooring, File calDirectory, String outfile, File[] infile) {
        this.calDirectory = calDirectory;
        Arrays.sort(infile);
        this.infile = infile;
        this.outfile = outfile;
        this.mooring = mooring.toLowerCase();
    }

    public void process() throws IOException, IllegalArgumentException {
        ProtoVariable lonV;
        ProtoVariable latV;
        ProtoVariable timeV;
        if (!this.calDirectory.isDirectory()) {
            throw new IllegalArgumentException(this.calDirectory.getCanonicalPath() + " is not a directory.");
        }
        Properties mooringProperties = new Properties();
        BufferedInputStream mooringPropertiesStream = new BufferedInputStream(new FileInputStream(new File(this.calDirectory, "mooring.properties")));
        mooringProperties.load(mooringPropertiesStream);
        mooringPropertiesStream.close();
        float[] lat = new float[]{Float.parseFloat(mooringProperties.getProperty(this.mooring + ".latitude", "-999"))};
        float[] lon = new float[]{Float.parseFloat(mooringProperties.getProperty(this.mooring + ".longitude", "-999"))};
        HRBinaryDecoder[] d = new HRBinaryDecoder[this.infile.length];
        for (int i = 0; i < d.length; ++i) {
            d[i] = new HRBinaryDecoder(this.infile[i], false);
            d[i].decode();
            HRPacket[] buf = d[i].getData();
            int n = buf.length;
            for (int j = 0; j < buf.length; ++j) {
                if (buf[j].RawTime >= 883612800) continue;
                --n;
                buf[j].RawTime = 0;
            }
            HRPacket[] newBuf = new HRPacket[n];
            int newN = 0;
            for (int j = 0; j < n; ++j) {
                if (buf[j].RawTime == 0) continue;
                newBuf[j] = buf[j];
                ++newN;
            }
            d[i].setData(newBuf);
        }
        String[] serialNumber0 = d[0].getSerialNumbers();
        String instrumentType0 = d[0].getInstrumentType();
        HRPacket[] data0 = d[0].getData();
        Object[] calList = this.calDirectory.list(new HRCalFileNameFilter(instrumentType0.toLowerCase(), serialNumber0[0]));
        Arrays.sort(calList);
        HRCalibrationFileReader[] calFiles = new HRCalibrationFileReader[calList.length];
        double[] calTime = new double[calList.length];
        for (int i = 0; i < calList.length; ++i) {
            calFiles[i] = new HRCalibrationFileReader(new File(this.calDirectory, (String)calList[i]));
            StringTokenizer st3 = new StringTokenizer((String)calList[i], ".");
            String tmp = st3.nextToken();
            tmp = st3.nextToken();
            tmp = st3.nextToken();
            int year = Integer.parseInt(tmp.substring(0, 4));
            int month = Integer.parseInt(tmp.substring(4, 6));
            int date = Integer.parseInt(tmp.substring(6, 8));
            calTime[i] = new GmtCalendar(year, month, date).getTime().getTime() / 1000L;
        }
        int good = 0;
        if ((double)data0[0].RawTime < calTime[0]) {
            good = 0;
        } else if ((double)data0[0].RawTime > calTime[calTime.length - 1]) {
            good = calTime.length - 1;
        } else {
            for (int i = 0; i < calTime.length - 1; ++i) {
                if (!((double)data0[0].RawTime >= calTime[i]) || !((double)data0[0].RawTime < calTime[i + 1])) continue;
                good = i;
                break;
            }
        }
        ProtoVariable[] schemaV = new ProtoVariable[3 + 6 * d.length];
        int n = 0;
        UnlimitedDimension timeD = new UnlimitedDimension("time");
        Attribute[] timeA = new Attribute[]{new Attribute("long_name", "time GMT"), new Attribute("units", "seconds since 1970-01-01 00:00:00")};
        schemaV[n] = timeV = new ProtoVariable("time", Double.TYPE, new Dimension[]{timeD}, timeA);
        ++n;
        Dimension[] lambdaD = new Dimension[this.infile.length];
        Attribute[] lambdaA = new Attribute[]{new Attribute("long_name", "wavelength"), new Attribute("units", "nanometers")};
        ProtoVariable[] lambdaV = new ProtoVariable[d.length];
        Dimension[] depthD = new Dimension[this.infile.length];
        Attribute[] depthA = new Attribute[]{new Attribute("long_name", "Sensor depth"), new Attribute("units", "meters")};
        ProtoVariable[] depthV = new ProtoVariable[d.length];
        ProtoVariable[] timeXV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            HRPacket[] data = d[i].getData();
            lambdaD[i] = new Dimension("wavelength" + d[i].getChannelNumber(), data[0].PixCount);
            lambdaV[i] = new ProtoVariable("wavelength" + d[i].getChannelNumber(), Float.TYPE, new Dimension[]{lambdaD[i]}, lambdaA);
            schemaV[n] = lambdaV[i];
            depthD[i] = new Dimension("depth" + d[i].getChannelNumber(), 1);
            depthV[i] = new ProtoVariable("depth" + d[i].getChannelNumber(), Float.TYPE, new Dimension[]{depthD[i]}, depthA);
            schemaV[++n] = depthV[i];
            Attribute[] timeXA = new Attribute[]{new Attribute("long_name", "Sample time for " + d[i].getDataType() + " sensor"), new Attribute("units", "seconds since 1970-01-01 00:00:00"), new Attribute("_FillValue", -999.0)};
            timeXV[i] = new ProtoVariable("time" + d[i].getChannelNumber(), Double.TYPE, new Dimension[]{timeD}, timeXA);
            schemaV[++n] = timeXV[i];
            ++n;
        }
        Dimension latD = new Dimension("latitude", 1);
        Attribute[] latA = new Attribute[]{new Attribute("long_name", "Latitude"), new Attribute("units", "degrees_east")};
        schemaV[n] = latV = new ProtoVariable("latitude", Float.TYPE, new Dimension[]{latD}, latA);
        Dimension lonD = new Dimension("longitude", 1);
        Attribute[] lonA = new Attribute[]{new Attribute("long_name", "Longitude"), new Attribute("units", "degrees_north")};
        schemaV[++n] = lonV = new ProtoVariable("longitude", Float.TYPE, new Dimension[]{lonD}, lambdaA);
        ++n;
        Attribute[] globalAtt = new Attribute[]{new Attribute("conventions", "MBARI/timeSeries/mooring/hydrorad"), new Attribute("creationDate", new Date().toString()), new Attribute("lastModified", new Date().toString()), new Attribute("mooring", "M1"), new Attribute("project", "Monterey Bay Time Series"), new Attribute("keywords", "spectroradiometer"), new Attribute("instrumentType", "Hobilabs " + instrumentType0), new Attribute("serialNumber", serialNumber0[0]), new Attribute("configurationFile", (String)calList[good])};
        ProtoVariable[] pressureV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            pressureV[i] = new ProtoVariable("pressure" + d[i].getChannelNumber(), Float.TYPE, new Dimension[]{timeD, depthD[i], latD, lonD}, new Attribute[]{new Attribute("long_name", "Pressure for channel " + d[i].getChannelNumber()), new Attribute("units", "dbar"), new Attribute("symbol", "Z"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
            schemaV[n] = pressureV[i];
            ++n;
        }
        ProtoVariable[] intTimeV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            intTimeV[i] = new ProtoVariable("intTime" + d[i].getChannelNumber(), Float.TYPE, new Dimension[]{timeD, depthD[i], latD, lonD}, new Attribute[]{new Attribute("long_name", "Integration time for channel " + d[i].getChannelNumber()), new Attribute("units", "seconds"), new Attribute("symbol", "I"), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
            schemaV[n] = intTimeV[i];
            ++n;
        }
        ProtoVariable[] dataV = new ProtoVariable[d.length];
        for (int i = 0; i < d.length; ++i) {
            dataV[i] = new ProtoVariable(d[i].getDataType(), Float.TYPE, new Dimension[]{timeD, lambdaD[i], depthD[i], latD, lonD}, new Attribute[]{new Attribute("long_name", d[i].getDataDescription()), new Attribute("units", d[i].getUnits()), new Attribute("symbol", d[i].getDataType()), new Attribute("_FillValue", -999.0), new Attribute("missing_value", -999.0)});
            schemaV[n] = dataV[i];
            ++n;
        }
        Schema schema = new Schema(schemaV, globalAtt);
        NetcdfFile nc = new NetcdfFile(this.outfile, true, true, schema);
        int[] origin1 = new int[]{0};
        int[] origin4 = new int[]{0, 0, 0, 0};
        int[] origin5 = new int[]{0, 0, 0, 0, 0};
        int timeLength = 0;
        int timeIndex = 0;
        for (int i = 0; i < d.length; ++i) {
            HRPacket[] data = d[i].getData();
            if (data.length <= timeLength) continue;
            timeLength = data.length;
            timeIndex = i;
        }
        HRPacket[] buf = d[timeIndex].getData();
        double[] timeBase = new double[buf.length];
        for (int r = 9; r < buf.length; ++r) {
            timeBase[r] = buf[r].RawTime;
        }
        ArrayMultiArray m = new ArrayMultiArray((Object)timeBase);
        Variable v = nc.get(timeV.getName());
        v.copyin(origin1, (MultiArray)m);
        m = new ArrayMultiArray((Object)lat);
        v = nc.get(latV.getName());
        v.copyin(origin1, (MultiArray)m);
        m = new ArrayMultiArray((Object)lon);
        v = nc.get(lonV.getName());
        v.copyin(origin1, (MultiArray)m);
        for (int i = 0; i < d.length; ++i) {
            HRPacket[] data = d[i].getData();
            String[] serialNumber = d[i].getSerialNumbers();
            String dataDescription = d[i].getDataDescription();
            String dataType = d[i].getDataType();
            String dataUnits = d[i].getUnits();
            String channel = d[i].getChannelNumber() + "";
            String instrumentType = d[i].getInstrumentType();
            double[] lambda = HRUtil.calcWavelength(data[0], calFiles[good].getWave(channel));
            float[] lambdaF = new float[lambda.length];
            for (int j = 0; j < lambda.length; ++j) {
                lambdaF[j] = (float)lambda[j];
            }
            double[] time = new double[data.length];
            float[] temp = new float[data.length];
            float[] voltage = new float[data.length];
            float[] pressure = new float[data.length];
            float[] intT = new float[data.length];
            float[][] dat = new float[data.length][lambda.length];
            float[] depth = new float[]{0.0f};
            for (int r = 0; r < data.length; ++r) {
                time[r] = data[r].RawTime;
                temp[r] = (float)data[r].Temp;
                voltage[r] = (float)data[r].Voltage;
                pressure[r] = (float)data[r].Depth;
                intT[r] = data[r].IntTime;
                dat[r] = new float[data[r].Pixel.length];
                for (int c = 0; c < dat[r].length; ++c) {
                    dat[r][c] = (float)data[r].Pixel[c];
                }
                depth[0] = depth[0] + pressure[r];
            }
            depth[0] = depth[0] / (float)data.length;
            m = new ArrayMultiArray((Object)depth);
            v = nc.get(depthV[i].getName());
            v.copyin(origin1, (MultiArray)m);
            m = new ArrayMultiArray((Object)lambdaF);
            v = nc.get(lambdaV[i].getName());
            v.copyin(origin1, (MultiArray)m);
            for (int k = 0; k < time.length; ++k) {
                double dt2;
                double dt1;
                int index = Arrays.binarySearch(timeBase, time[k]);
                if (index < -1 && (index = -(index + 1)) < timeBase.length && index > 0 && (dt1 = Math.abs(timeBase[index - 1] - time[k])) < (dt2 = Math.abs(timeBase[index] - time[k]))) {
                    --index;
                }
                if (index < 0) continue;
                int[] origin_5 = new int[]{index, 0, 0, 0, 0};
                int[] origin_4 = new int[]{index, 0, 0, 0};
                int[] origin_1 = new int[]{index};
                m = new ArrayMultiArray((Object)dat);
                v = nc.get(dataV[i].getName());
                for (int ii = 0; ii < lambdaF.length; ++ii) {
                    v.setFloat(new int[]{index, ii, 0, 0, 0}, dat[k][ii]);
                }
                v = nc.get(timeXV[i].getName());
                v.setDouble(origin_1, time[k]);
                v = nc.get(pressureV[i].getName());
                v.setFloat(origin_4, pressure[k]);
                v = nc.get(intTimeV[i].getName());
                v.setFloat(origin_4, intT[k]);
            }
        }
        nc.close();
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: java org.mbari.hobilabs.hr.HRNetcdfConstructor <mooring> <Directory containing cal files> <outfile> <infile1> <infile2> ...");
            System.exit(0);
        }
        File[] infile = new File[args.length - 3];
        for (int i = 3; i < args.length; ++i) {
            infile[i - 3] = new File(args[i]);
        }
        HRNetcdfConstructor main = new HRNetcdfConstructor(args[0], new File(args[1]), args[2], infile);
        try {
            main.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

