/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mbari.io.AsciiHexReader;
import org.mbari.util.MathUtil;

public class HRDataCleaner {
    File[] files;
    File dest;
    String prefix;
    private static final Log log = LogFactory.getLog((Class)(class$org$mbari$oasis$HRDataCleaner == null ? (class$org$mbari$oasis$HRDataCleaner = HRDataCleaner.class$("org.mbari.oasis.HRDataCleaner")) : class$org$mbari$oasis$HRDataCleaner));
    static /* synthetic */ Class class$org$mbari$oasis$HRDataCleaner;

    public HRDataCleaner(File infile, File dest, String prefix) throws IOException {
        if (infile.isDirectory()) {
            this.files = infile.listFiles();
        } else if (infile.isFile()) {
            this.files = new File[1];
            this.files[0] = infile;
        }
        this.dest = dest;
        this.prefix = prefix;
    }

    public HRDataCleaner(String infile, String dest, String prefix) throws IOException {
        this(new File(infile), new File(dest), prefix);
    }

    public HRDataCleaner(String infile, String dest) throws IOException {
        this(new File(infile), new File(dest), "");
    }

    public HRDataCleaner(File infile, File dest) throws IOException {
        this(infile, dest, "");
    }

    public void seperate() throws IOException {
        BufferedOutputStream out;
        if (!this.dest.isDirectory()) {
            // empty if block
        }
        if (!this.dest.canWrite()) {
            throw new IOException("Unable to write to " + this.dest.getCanonicalFile());
        }
        HashMap<String, BufferedOutputStream> hm = new HashMap<String, BufferedOutputStream>();
        for (int i = 0; i < this.files.length; ++i) {
            if (!this.files[i].canRead()) {
                log.warn((Object)("Unable to read " + this.files[i].getCanonicalPath()));
                continue;
            }
            BufferedReader in = new BufferedReader(new FileReader(this.files[i]));
            String str = "";
            String S = "";
            while ((str = in.readLine()) != null) {
                int end;
                StringTokenizer st = new StringTokenizer(str);
                try {
                    S = st.nextToken();
                    S = st.nextToken();
                }
                catch (NoSuchElementException e) {
                    continue;
                }
                int start = S.indexOf("4852");
                if (start < 0 || (end = S.toLowerCase().lastIndexOf("0d0a")) < 0) continue;
                end += 4;
                try {
                    S = S.substring(start, end);
                }
                catch (Exception e) {
                    log.warn((Object)("Choked on line '" + S + "' in " + this.files[i]));
                    continue;
                }
                char[] C = S.toCharArray();
                if (!MathUtil.isEven(C.length)) continue;
                AsciiHexReader ahr = new AsciiHexReader(new CharArrayReader(C));
                char[] id = new char[3];
                char[] sn = new char[8];
                try {
                    id[0] = ahr.readChar();
                    id[1] = ahr.readChar();
                    id[2] = ahr.readChar();
                    char trash = ahr.readChar();
                    for (int n = 0; n < 8; ++n) {
                        sn[n] = ahr.readChar();
                    }
                }
                catch (EOFException e) {
                    continue;
                }
                String key = new String(sn);
                if (!hm.containsKey(key)) {
                    File destination = new File(this.dest, key + "_" + this.prefix + ".bin");
                    hm.put(key, new BufferedOutputStream(new FileOutputStream(destination)));
                }
                out = (BufferedOutputStream)hm.get(key);
                ahr.reset();
                for (int k = 0; k < C.length / 2; ++k) {
                    try {
                        out.write(ahr.readUnsignedByte());
                        continue;
                    }
                    catch (EOFException e) {
                        // empty catch block
                    }
                }
            }
            in.close();
        }
        Object[] keys = hm.keySet().toArray();
        for (int i = 0; i < keys.length; ++i) {
            out = (BufferedOutputStream)hm.get((String)keys[i]);
            out.close();
        }
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("\nUse as: org.mbari.oasis.HRDataCleaner <filename or dataDirectory> <outputDirectory> <outputNamePrefix>\n");
            System.err.println("<filename> specifies the name of the file to process. Alternatively you may specify a <dataDirectory>, the name of a directory that only contains HR data files. All files in the <dataDirectory> will be processed\n\n<outputDirectory> specifies the destination directory to write to.\n\n<outputNamePrefix> specifies the prefix to prepend onto the output filenames. Its generally best to name it the same as the directory that contains the data files. (ex. hr1)");
            System.err.println("\nHRDataCleaner is used to turn the hex dumped hydrorad data thats returned by Oasis into binary files");
            System.exit(0);
        }
        try {
            HRDataCleaner hds = new HRDataCleaner(args[0], args[1], args[2]);
            hds.seperate();
        }
        catch (FileNotFoundException e) {
            log.fatal((Object)"Failed!!", (Throwable)e);
        }
        catch (IOException e) {
            log.fatal((Object)"Failed!!", (Throwable)e);
        }
        catch (Exception e) {
            log.fatal((Object)"Failed!!", (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

