/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import org.mbari.oasis.CalibrationHistory;
import org.mbari.util.TimeUtil;

public class CalibrationHistoryFactory {
    private File cfgFile;

    public CalibrationHistoryFactory(String cfgFile) {
        this(new File(cfgFile));
    }

    public CalibrationHistoryFactory(File cfgFile) {
    }

    public CalibrationHistory getHistory(String instrumentType) throws IOException {
        String str;
        CalibrationHistory ch = new CalibrationHistory(instrumentType);
        BufferedReader in = new BufferedReader(new FileReader(this.cfgFile));
        while ((str = in.readLine()) != null) {
            StringTokenizer st;
            if (str.toLowerCase().startsWith(instrumentType.toLowerCase())) {
                st = new StringTokenizer(str);
                if (st.countTokens() != 2) break;
                String buf = st.nextToken();
                String filename = new File(st.nextToken()).getName();
                ch.setDefault(filename);
                break;
            }
            if (!str.startsWith("9") && !str.startsWith("1") && !str.startsWith("2") || (st = new StringTokenizer(str)).countTokens() <= 4) continue;
            String date1 = st.nextToken();
            int yearIndex = 2;
            if (date1.length() >= 9) {
                yearIndex = 4;
            }
            double year1 = Double.parseDouble(date1.substring(0, yearIndex));
            double day1 = Double.parseDouble(date1.substring(yearIndex, date1.length()));
            Date start = TimeUtil.dayOfYearToDate(day1, year1);
            String buf = st.nextToken();
            String date2 = st.nextToken();
            yearIndex = 2;
            if (date2.length() >= 9) {
                yearIndex = 4;
            }
            double year2 = Double.parseDouble(date2.substring(0, yearIndex));
            double day2 = Double.parseDouble(date2.substring(yearIndex, date2.length()));
            Date end = TimeUtil.dayOfYearToDate(day2, year2);
            String type = st.nextToken();
            if (!type.toLowerCase().startsWith(instrumentType.toLowerCase())) continue;
            String cfg = st.nextToken();
            String history = new File(st.nextToken()).getName();
            ch.set(start, end, history);
        }
        in.close();
        return ch;
    }
}

