/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.io;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import org.mbari.io.OasisPco2Reader2;

public class OasisPco2Writer {
    private OasisPco2Reader2 r;

    public OasisPco2Writer(String filename) throws IOException {
        this.r = new OasisPco2Reader2(filename);
    }

    public static void main(String[] args) {
        try {
            OasisPco2Writer w = new OasisPco2Writer(args[0]);
            w.write(args[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void write(String filename) throws IOException {
        double[] calData = this.r.getCalData();
        long[] calTime = this.r.getCalTime();
        BufferedWriter out = new BufferedWriter(new FileWriter(filename + ".cal"));
        out.write("% pCO2 calibration data parsed by Brian Schlining\n");
        out.write("% Column 1: Sample time (in UTC, i.e. milliseconds since Jan 01 1970 00:00:00[GMT])\n");
        out.write("% Column 2: pCO2 calibration value\n");
        for (int i = 0; i < calTime.length; ++i) {
            out.write(calTime[i] + "\t");
            out.write(calData[i] + "\n");
        }
        out.close();
        double[] data = this.r.getData();
        long[] time = this.r.getTime();
        out = new BufferedWriter(new FileWriter(filename + ".data"));
        out.write("% pCO2 data parsed by Brian Schlining\n");
        out.write("% Column 1: Sample time (in UTC, i.e. milliseconds since Jan 01 1970 00:00:00[GMT])\n");
        out.write("% Column 2: pCO2 data value\n");
        for (int i = 0; i < time.length; ++i) {
            out.write(time[i] + "\t");
            out.write(data[i] + "\n");
        }
        out.close();
    }
}

