/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import org.mbari.util.DateConverter;

public class OasisPco2Reader2 {
    private File file;
    private long[] dataTime;
    private long[] calTime;
    private double[] data;
    private double[] cal;
    private static final int COLUMNS_CAL = 7;
    private static final int COLUMNS_DATA = 6;

    public OasisPco2Reader2(String s) throws IOException {
        this.file = new File(s);
        this.init();
        this.read();
    }

    public OasisPco2Reader2(File f) throws IOException {
        this.file = f;
        this.init();
        this.read();
    }

    public double[] getData() {
        return this.data;
    }

    public long[] getTime() {
        return this.dataTime;
    }

    public double[] getCalData() {
        return this.cal;
    }

    public long[] getCalTime() {
        return this.calTime;
    }

    private void init() throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        int numCal = 0;
        int numData = 0;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("%")) continue;
            StringTokenizer st = new StringTokenizer(line);
            int n = st.countTokens();
            switch (n) {
                case 7: {
                    int OK = line.indexOf(67);
                    if (OK == -1) break;
                    ++numCal;
                    break;
                }
                case 6: {
                    ++numData;
                }
            }
        }
        in.close();
        this.cal = new double[numCal];
        this.data = new double[numData];
        this.calTime = new long[numCal];
        this.dataTime = new long[numData];
    }

    private void read() throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        int calRow = 0;
        int dataRow = 0;
        while ((line = in.readLine()) != null) {
            if (line.startsWith("#") || line.startsWith("%")) continue;
            StringTokenizer st = new StringTokenizer(line);
            int NumOfCol = st.countTokens();
            switch (NumOfCol) {
                case 7: {
                    String tmp;
                    int OK = line.indexOf(67);
                    if (OK == -1) break;
                    int currentCol = 0;
                    double dayOfYear = 0.0;
                    double year = 0.0;
                    while (st.hasMoreTokens()) {
                        switch (currentCol) {
                            case 0: {
                                dayOfYear = new Double(st.nextToken());
                                break;
                            }
                            case 1: {
                                this.cal[calRow] = new Double(st.nextToken());
                                break;
                            }
                            case 6: {
                                year = new Double(st.nextToken());
                                this.calTime[calRow] = DateConverter.doyToDate(dayOfYear, year).getTime();
                                break;
                            }
                            default: {
                                tmp = st.nextToken();
                            }
                        }
                        ++currentCol;
                    }
                    ++calRow;
                    break;
                }
                case 6: {
                    String tmp;
                    int currentCol = 0;
                    double dayOfYear = 0.0;
                    double year = 0.0;
                    while (st.hasMoreTokens()) {
                        switch (currentCol) {
                            case 0: {
                                dayOfYear = new Double(st.nextToken());
                                break;
                            }
                            case 1: {
                                this.data[dataRow] = new Double(st.nextToken());
                                break;
                            }
                            case 5: {
                                year = new Double(st.nextToken());
                                this.dataTime[dataRow] = DateConverter.doyToDate(dayOfYear, year).getTime();
                                break;
                            }
                            default: {
                                tmp = st.nextToken();
                            }
                        }
                        ++currentCol;
                    }
                    ++dataRow;
                }
            }
        }
    }

    public static void main(String[] args) {
        try {
            OasisPco2Reader2 r = new OasisPco2Reader2("g:/m1/data/pco2");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println();
    }
}

