/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class DelimitedFile {
    File file;
    protected double[][] data;
    private int numOfColumns = 0;
    private int numOfRows = 0;
    private boolean hasColumnNames = false;
    private String delimiter = " \t\n\r\f";
    private String commentTag;
    protected String[] columnNames;

    public DelimitedFile(String filename) throws IOException {
        this(new File(filename));
    }

    public DelimitedFile(File file) throws IOException {
        this.file = file;
    }

    public void readFile() throws IOException {
        this.init();
        this.parse();
    }

    public void read() throws IOException {
        this.init();
        this.parse();
    }

    public double[][] getData() {
        return this.data;
    }

    public String getFilename() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    public double getDatum(int row, int column) {
        return this.data[row][column];
    }

    public int getNumOfRows() {
        return this.numOfRows;
    }

    public int getNumOfColumns() {
        return this.numOfColumns;
    }

    private void init() throws IOException {
        String line;
        if (!this.file.exists() || !this.file.canRead()) {
            throw new IOException("Unable to read " + this.file.getAbsolutePath());
        }
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        boolean readHeaders = false;
        if (this.hasColumnNames) {
            readHeaders = true;
        }
        while ((line = in.readLine()) != null) {
            if (this.commentTag != null && line.startsWith(this.commentTag)) continue;
            if (readHeaders) {
                readHeaders = false;
                continue;
            }
            if (this.numOfColumns == 0) {
                StringTokenizer st = new StringTokenizer(line, this.delimiter);
                this.numOfColumns = st.countTokens();
            }
            ++this.numOfRows;
        }
        this.data = new double[this.numOfRows][this.numOfColumns];
        in.close();
    }

    private void parse() throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(this.file));
        int row = 0;
        int column = 0;
        boolean good = false;
        boolean bad = false;
        boolean readHeaders = false;
        if (this.hasColumnNames) {
            readHeaders = true;
        }
        while ((line = in.readLine()) != null) {
            StringTokenizer st;
            if (this.commentTag != null && line.startsWith(this.commentTag)) continue;
            if (readHeaders) {
                st = new StringTokenizer(line, this.delimiter);
                if (st.countTokens() != this.numOfColumns) {
                    in.close();
                    throw new IOException("Number of column headers (" + st.countTokens() + ") does not " + "match the number of columns (" + this.numOfColumns + ") in the data.");
                }
                int i = 0;
                this.columnNames = new String[this.numOfColumns];
                while (st.hasMoreTokens()) {
                    this.columnNames[i] = st.nextToken();
                    ++i;
                }
                readHeaders = false;
                continue;
            }
            st = new StringTokenizer(line, this.delimiter);
            column = 0;
            while (st.hasMoreTokens()) {
                try {
                    this.data[row][column] = Double.parseDouble(st.nextToken());
                }
                catch (NumberFormatException e) {
                    this.data[row][column] = Double.NaN;
                }
                ++column;
            }
            ++row;
        }
        in.close();
    }

    public void setHasColumnNames(boolean newHasColumnNames) {
        this.hasColumnNames = newHasColumnNames;
    }

    public boolean getHasColumnNames() {
        return this.hasColumnNames;
    }

    public void setDelimiter(String newDelimiter) {
        this.delimiter = newDelimiter;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setCommentTag(String newCommentTag) {
        this.commentTag = newCommentTag;
    }

    public String getCommentTag() {
        return this.commentTag;
    }

    public static void main(String[] args) {
        try {
            DelimitedFile reader = new DelimitedFile(args[0]);
            reader.setDelimiter(",");
            reader.setHasColumnNames(true);
            reader.read();
            double[][] data = reader.getData();
            System.out.println("Read " + data.length + " rows and " + data[0].length + " columns from " + reader.getFile().getName());
            System.out.println("Last data point in row " + (data.length - 2) + " is " + data[data.length - 3][data[0].length - 1]);
            System.out.println("Last data point in row " + (data.length - 1) + " is " + data[data.length - 2][data[0].length - 1]);
            System.out.println("Last data point in row " + data.length + " is " + data[data.length - 1][data[0].length - 1]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

