/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.hobilabs;

import org.mbari.hobilabs.HSDPacket;

public class HSDParser {
    private HSDParser() {
    }

    public static HSDPacket parse(String S) throws IllegalArgumentException {
        if (!S.startsWith("*D") || S.length() < 59) {
            throw new IllegalArgumentException("Invalid Data Packet");
        }
        String[] hex = new String[]{S.substring(2, 10), S.substring(10, 14), S.substring(14, 18), S.substring(18, 22), S.substring(22, 26), S.substring(26, 30), S.substring(30, 34), S.substring(34, 38), S.substring(38, 42), S.substring(42, 43), S.substring(43, 44), S.substring(44, 45), S.substring(45, 46), S.substring(46, 47), S.substring(47, 48), S.substring(48, 49), S.substring(49, 50), S.substring(50, 54), S.substring(54, 56), S.substring(56, 58), S.substring(58, 60)};
        int hexIndex = 0;
        long time = (long)HSDParser.toSignedInt(hex[hexIndex]) * 1000L;
        ++hexIndex;
        int[] sNorm = new int[8];
        for (int i = 0; i < sNorm.length; ++i) {
            sNorm[i] = HSDParser.toSignedInt(hex[hexIndex]);
            ++hexIndex;
        }
        int[] gain = new int[8];
        for (int i = 0; i < gain.length; ++i) {
            gain[i] = Integer.parseInt(hex[hexIndex]);
            ++hexIndex;
        }
        int depth = HSDParser.toSignedInt(hex[hexIndex]);
        int temperature = Integer.parseInt(hex[++hexIndex], 16);
        byte error = (byte)Integer.parseInt(hex[++hexIndex], 16);
        hex = null;
        return new HSDPacket(time, sNorm, gain, depth, temperature, error);
    }

    private static int toSignedInt(String S) {
        int i = Integer.parseInt(S, 16);
        int L = S.length();
        long maxValue = 0L;
        long minValue = 0L;
        if (L == 4) {
            maxValue = 32767L;
            minValue = -32768L;
        } else if (L == 8) {
            maxValue = Integer.MAX_VALUE;
            minValue = Integer.MIN_VALUE;
        }
        if ((long)i > maxValue) {
            i += (int)minValue * 2;
        }
        return i;
    }
}

