/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.hobilabs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;

public class HS2CalibrationFileReader {
    private Properties prop = new Properties();

    public HS2CalibrationFileReader(String filename) throws IOException {
        this.parse(new File(filename));
    }

    public HS2CalibrationFileReader(File file) throws IOException {
        this.parse(file);
    }

    public Properties getProperties() {
        return this.prop;
    }

    private void parse(File file) throws IOException {
        if (file.isDirectory()) {
            throw new IOException("You dolt! " + file.getName() + " is a directory, not a file.");
        }
        if (!file.canRead()) {
            throw new IOException("Unable to read " + file.getName() + ". Check the files permissions.");
        }
        BufferedReader in = new BufferedReader(new FileReader(file));
        String S = null;
        boolean isTag = true;
        String tag = "none";
        String prefix = "";
        while ((S = in.readLine()) != null) {
            isTag = this.checkForTag(S);
            if (isTag) {
                StringTokenizer st1 = new StringTokenizer(S, "]");
                tag = (S = st1.nextToken()).substring(1, S.length());
                if (tag.startsWith("Channel")) {
                    prefix = tag + ".";
                    continue;
                }
                if (tag.startsWith("General") | tag.startsWith("Start")) {
                    prefix = "";
                    continue;
                }
                if (!tag.startsWith("End")) continue;
                break;
            }
            StringTokenizer st2 = new StringTokenizer(S, "=");
            try {
                String param = st2.nextToken();
                if (param == null) continue;
                String name = prefix + param;
                String value = st2.nextToken();
                if (value == null) {
                    value = "";
                }
                this.prop.put(name, value);
            }
            catch (NoSuchElementException e) {}
        }
        in.close();
        String tempNom = this.prop.getProperty("TempNom");
        if (tempNom == null) {
            this.prop.put("TempNom", new String("1.0"));
        }
    }

    private boolean checkForTag(String S) {
        boolean isTag = false;
        if (S.startsWith("[") & S.endsWith("]")) {
            isTag = true;
        }
        return isTag;
    }
}

