/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.hobilabs;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.mbari.hobilabs.HRPacket;
import org.mbari.hobilabs.HRParser;

public class HRBinaryDecoder {
    private String instrumentType;
    private String channelInformation;
    private String dataType;
    private String units;
    private File infile;
    private ArrayList serialNumbers = new ArrayList();
    private HRPacket[] data;
    private boolean getAllSerialNumbers;
    private int channel = -1;

    public HRBinaryDecoder(File infile) {
        this(infile, false);
    }

    public HRBinaryDecoder(String infile) {
        this(new File(infile), false);
    }

    public HRBinaryDecoder(String infile, boolean getAllSerialNumbers) {
        this(new File(infile), getAllSerialNumbers);
    }

    public HRBinaryDecoder(File infile, boolean getAllSerialNumbers) {
        this.infile = infile;
        this.getAllSerialNumbers = getAllSerialNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decode() throws IOException {
        DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.infile)));
        char[] c = new char[1];
        char[] serialNumber = new char[8];
        StringBuffer channelInfo = new StringBuffer();
        boolean firstLoop = true;
        try {
            while (true) {
                c[0] = (char)in.readUnsignedByte();
                if (!new Character(c[0]).equals(new Character('H'))) continue;
                c[0] = (char)in.readUnsignedByte();
                if (!new Character(c[0]).equals(new Character('R'))) continue;
                c[0] = (char)in.readUnsignedByte();
                if (!Character.isDigit(c[0])) continue;
                char type = c[0];
                c[0] = (char)in.readUnsignedByte();
                if (!new Character(c[0]).equals(new Character(','))) continue;
                c[0] = (char)in.readUnsignedByte();
                if (!new Character(c[0]).equals(new Character('H'))) continue;
                c[0] = (char)in.readUnsignedByte();
                if (!new Character(c[0]).equals(new Character('R'))) continue;
                serialNumber[0] = 72;
                serialNumber[1] = 82;
                for (int i = 2; i < 8; ++i) {
                    serialNumber[i] = (char)in.readUnsignedByte();
                }
                this.serialNumbers.add(new String(serialNumber));
                if (!firstLoop) continue;
                this.instrumentType = "HR" + type;
                c[0] = (char)in.readUnsignedByte();
                while (true) {
                    firstLoop = false;
                    int a = in.readUnsignedByte();
                    if (a == 10) break;
                    channelInfo.append((char)a);
                }
                this.channelInformation = new String(channelInfo);
                if (!this.getAllSerialNumbers) break;
            }
        }
        catch (EOFException e) {
        }
        finally {
            in.close();
        }
        in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.infile)));
        HRParser p = new HRParser(in);
        p.parse();
        this.data = p.get();
        in.close();
    }

    public HRPacket[] getData() {
        return this.data;
    }

    public void setData(HRPacket[] data) {
        this.data = data;
    }

    public String[] getSerialNumbers() {
        Object[] buf = this.serialNumbers.toArray();
        String[] out = new String[buf.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (String)buf[i];
        }
        return out;
    }

    public String getInstrumentType() {
        return this.instrumentType;
    }

    public String getDataDescription() {
        return this.channelInformation;
    }

    public int getChannelNumber() {
        if (this.channel == -1) {
            StringTokenizer st = new StringTokenizer(this.channelInformation, ",");
            String channelS = st.nextToken();
            st = new StringTokenizer(channelS);
            String buf = st.nextToken();
            this.channel = Integer.parseInt(st.nextToken().trim());
        }
        return this.channel;
    }

    public String getDataType() {
        if (this.dataType == null) {
            StringTokenizer st = new StringTokenizer(this.channelInformation, ",");
            String buf = st.nextToken();
            this.dataType = st.nextToken().trim();
        }
        return this.dataType;
    }

    public String getUnits() {
        if (this.units == null) {
            StringTokenizer st = new StringTokenizer(this.channelInformation, ",");
            String buf = st.nextToken();
            buf = st.nextToken();
            this.units = st.nextToken().trim();
        }
        return this.units;
    }
}

