/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.gis.util;

import java.awt.geom.Point2D;

public class GisUtil {
    private GisUtil() {
    }

    public static final Point2D geoToUtm(double longitude, double latitude, int ZoneNumber) {
        double a = 6378137.0;
        double eccSquared = 0.00669438;
        double k0 = 0.9996;
        double longTemp = longitude + 180.0 - (double)((int)((longitude + 180.0) / 360.0) * 360) - 180.0;
        double latRad = Math.toRadians(latitude);
        double longRad = Math.toRadians(longitude);
        double longOrigin = (ZoneNumber - 1) * 6 - 180 + 3;
        double longOriginRad = Math.toRadians(longOrigin);
        double eccPrimeSquared = eccSquared / (1.0 - eccSquared);
        double N = a / Math.sqrt(1.0 - eccSquared * Math.sin(latRad) * Math.sin(latRad));
        double T = Math.tan(latRad) * Math.tan(latRad);
        double C = eccPrimeSquared * Math.cos(latRad) * Math.cos(latRad);
        double A = Math.cos(latRad) * (longRad - longOriginRad);
        double M = a * ((1.0 - eccSquared / 4.0 - 3.0 * eccSquared * eccSquared / 64.0 - 5.0 * eccSquared * eccSquared * eccSquared / 256.0) * latRad - (3.0 * eccSquared / 8.0 + 3.0 * eccSquared * eccSquared / 32.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(2.0 * latRad) + (15.0 * eccSquared * eccSquared / 256.0 + 45.0 * eccSquared * eccSquared * eccSquared / 1024.0) * Math.sin(4.0 * latRad) - 35.0 * eccSquared * eccSquared * eccSquared / 3072.0 * Math.sin(6.0 * latRad));
        double utmEasting = k0 * N * (A + (1.0 - T + C) * A * A * A / 6.0 + (5.0 - 18.0 * T + T * T + 72.0 * C - 58.0 * eccPrimeSquared) * A * A * A * A * A / 120.0) + 500000.0;
        double utmNorthing = k0 * (M + N * Math.tan(latRad) * (A * A / 2.0 + (5.0 - T + 9.0 * C + 4.0 * C * C) * A * A * A * A / 24.0 + (61.0 - 58.0 * T + T * T + 600.0 * C - 330.0 * eccPrimeSquared) * A * A * A * A * A * A / 720.0));
        if (latitude < 0.0) {
            utmNorthing += 1.0E7;
        }
        return new Point2D.Double(utmEasting, utmNorthing);
    }
}

