/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.png;

import com.visualtek.png.PNGException;
import com.visualtek.png.PNGInfo;
import com.visualtek.png.PNGRowHandler;

class PNGTrueColorRowHandler
extends PNGRowHandler {
    PNGInfo info;
    int size;
    boolean hasAlpha;

    private PNGTrueColorRowHandler() {
    }

    PNGTrueColorRowHandler(PNGInfo pNGInfo) throws PNGException {
        this.info = pNGInfo;
        boolean bl = this.hasAlpha = (this.info.color_type & 4) == 4;
        if (this.info.bit_depth == 8) {
            this.size = 1;
            return;
        }
        if (this.info.bit_depth == 16) {
            this.size = 2;
            return;
        }
        throw new PNGException("Not supported number of bit per pixel = " + this.info.bit_depth);
    }

    void transformRow(byte[] byArray, int n, int[] nArray, int n2) throws PNGException {
        int n3 = n;
        try {
            while (n3 < byArray.length) {
                int n4 = byArray[n3] & 0xFF;
                int n5 = byArray[n3 += this.size] & 0xFF;
                int n6 = byArray[n3 += this.size] & 0xFF;
                n3 += this.size;
                if (this.hasAlpha) {
                    n3 += this.size;
                }
                nArray[n2++] = 0xFF000000 | n4 << 16 | n5 << 8 | n6;
            }
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    void transformRowBytes(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n) throws PNGException {
        int n2 = 0;
        try {
            while (n2 < byArray.length) {
                byArray2[n] = (byte)(byArray[n2] & 0xFF);
                byArray3[n] = (byte)(byArray[n2 += this.size] & 0xFF);
                byArray4[n] = (byte)(byArray[n2 += this.size] & 0xFF);
                n2 += this.size;
                if (this.hasAlpha) {
                    n2 += this.size;
                }
                ++n;
            }
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }
}

