/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.png;

import com.visualtek.png.PNGDataDecoder;
import com.visualtek.png.PNGException;
import com.visualtek.png.PNGInfo;
import com.visualtek.png.PNGRowHandler;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class PNGProducer
implements ImageProducer {
    byte[] pixels_red;
    byte[] pixels_green;
    byte[] pixels_blue;
    byte[] pixels_alpha;
    PNGInfo info;
    PNGRowHandler rowHandler;
    private ColorModel colorModel = ColorModel.getRGBdefault();
    private ImageConsumer theConsumer;
    private boolean initialised = false;

    public PNGProducer() throws PNGException, IOException {
        this.initialised = false;
    }

    public PNGProducer(InputStream inputStream) throws PNGException, IOException {
        this.init(inputStream);
        this.initialised = true;
    }

    public void init(InputStream inputStream) throws PNGException, IOException {
        PNGDataDecoder pNGDataDecoder = new PNGDataDecoder(inputStream);
        this.info = pNGDataDecoder.readInfo();
        if (this.info.interlace_type != 0) {
            throw new PNGException("Interlaced PNG image not supported.");
        }
        int n = this.info.width * this.info.height;
        this.pixels_red = new byte[n];
        this.pixels_green = new byte[n];
        this.pixels_blue = new byte[n];
        byte[] byArray = new byte[this.info.rowbytes];
        pNGDataDecoder.readStartRow();
        int n2 = 0;
        while (n2 < n) {
            pNGDataDecoder.readRow(byArray, 0);
            pNGDataDecoder.row_info.transformRowBytes(byArray, this.pixels_red, this.pixels_green, this.pixels_blue, this.pixels_alpha, n2);
            n2 += this.info.width;
        }
        pNGDataDecoder.readEnd();
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        this.theConsumer = imageConsumer;
        this.produce();
        this.theConsumer = null;
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.theConsumer;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.theConsumer == imageConsumer) {
            this.theConsumer = null;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void produce() {
        ImageConsumer imageConsumer = this.theConsumer;
        if (imageConsumer != null) {
            imageConsumer.setDimensions(this.info.width, this.info.height);
            imageConsumer.setProperties(new Hashtable());
            imageConsumer.setColorModel(this.colorModel);
            imageConsumer.setHints(30);
            int[] nArray = new int[this.info.width];
            int n = 0;
            int n2 = 0;
            while (n2 < this.info.height) {
                int n3 = 0;
                while (n3 < this.info.width) {
                    nArray[n3] = 0xFF000000 | (this.pixels_red[n] & 0xFF) << 16 | (this.pixels_green[n] & 0xFF) << 8 | this.pixels_blue[n] & 0xFF;
                    ++n3;
                    ++n;
                }
                imageConsumer.setPixels(0, n2, this.info.width, 1, this.colorModel, nArray, 0, this.info.width);
                ++n2;
            }
            imageConsumer.imageComplete(3);
        }
    }
}

