/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.png;

import com.visualtek.png.PNGDataEncoder;
import com.visualtek.png.PNGException;
import com.visualtek.png.PNGInfo;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

public class PNGEncoder
implements ImageConsumer {
    PNGDataEncoder Encoder;
    PNGInfo Info;
    ImageProducer Producer;
    int HintFlags;
    int Width;
    int Height;
    boolean InProgress;
    PNGException EncodeException;
    IOException OutputException;
    OutputStream Out;
    boolean CloseOut;
    byte[] RawBuffer;

    public PNGEncoder() {
    }

    public PNGEncoder(Image image, String string) throws IOException {
        this(image.getSource(), (OutputStream)new FileOutputStream(string));
        this.CloseOut = true;
    }

    public PNGEncoder(Image image, OutputStream outputStream) {
        this(image.getSource(), outputStream);
    }

    public PNGEncoder(ImageProducer imageProducer, OutputStream outputStream) {
        this.setOutput(outputStream);
        this.setImage(imageProducer);
        this.InProgress = false;
    }

    public void setImage(ImageProducer imageProducer) {
        this.Producer = imageProducer;
    }

    public void setImage(Image image) {
        if (image != null) {
            this.Producer = image.getSource();
        }
    }

    public void setOutput(OutputStream outputStream) {
        this.Out = outputStream;
        this.CloseOut = false;
    }

    public void encode() throws PNGException, IOException {
        if (this.Producer != null && this.Out != null) {
            this.EncodeException = null;
            this.OutputException = null;
            this.Encoder = new PNGDataEncoder(this.Out);
            this.Info = new PNGInfo();
            this.RawBuffer = null;
            this.HintFlags = 0;
            this.Width = 0;
            this.Height = 0;
            this.InProgress = true;
            this.Producer.startProduction(this);
            while (this.InProgress) {
                PNGEncoder pNGEncoder = this;
                synchronized (pNGEncoder) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            if (this.EncodeException != null) {
                throw this.EncodeException;
            }
            if (this.OutputException != null) {
                throw this.OutputException;
            }
            if (this.Out != null && this.CloseOut) {
                this.Out.flush();
                this.Out.close();
            }
        }
    }

    public void setDimensions(int n, int n2) {
        this.Width = n;
        this.Height = n2;
    }

    public void setProperties(Hashtable hashtable) {
    }

    public void setColorModel(ColorModel colorModel) {
    }

    public void setHints(int n) {
        this.HintFlags = n;
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        try {
            int n7 = n5;
            if (this.RawBuffer == null) {
                this.RawBuffer = new byte[this.Width * this.Height * 3];
            }
            int n8 = 0;
            while (n8 < n4) {
                int n9 = n + (n2 + n8) * this.Width * 3;
                int n10 = n7;
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = 0xFF & byArray[n10++];
                    this.RawBuffer[n9++] = (byte)colorModel.getRed(n12);
                    this.RawBuffer[n9++] = (byte)colorModel.getGreen(n12);
                    this.RawBuffer[n9++] = (byte)colorModel.getBlue(n12);
                    ++n11;
                }
                n7 += n6;
                ++n8;
            }
            return;
        }
        catch (Exception exception) {
            this.EncodeException = new PNGException(exception.toString());
            this.encodeDone();
            return;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7 = n5;
        try {
            if (this.RawBuffer == null) {
                this.RawBuffer = new byte[this.Width * this.Height * 3];
            }
            int n8 = 0;
            while (n8 < n4) {
                int n9 = n + (n2 + n8) * this.Width * 3;
                int n10 = n7;
                int n11 = 0;
                while (n11 < n3) {
                    int n12 = nArray[n10++];
                    this.RawBuffer[n9++] = (byte)colorModel.getRed(n12);
                    this.RawBuffer[n9++] = (byte)colorModel.getGreen(n12);
                    this.RawBuffer[n9++] = (byte)colorModel.getBlue(n12);
                    ++n11;
                }
                n7 += n6;
                ++n8;
            }
            return;
        }
        catch (Exception exception) {
            this.EncodeException = new PNGException(exception.toString());
            this.encodeDone();
            return;
        }
    }

    public void imageComplete(int n) {
        this.Producer.removeConsumer(this);
        if ((n & 4) != 0) {
            this.OutputException = new IOException("Image transfer aborted");
        } else if (this.RawBuffer != null && this.Width > 0) {
            try {
                this.Info.width = this.Width;
                this.Info.height = this.Height;
                this.Info.bit_depth = (byte)8;
                this.Info.color_type = (byte)2;
                this.Info.channels = (byte)3;
                this.Encoder.writeInfo(this.Info);
                int n2 = this.Width * 3;
                int n3 = 0;
                while (n3 < this.Height) {
                    this.Encoder.writeRow(this.RawBuffer, n3 * n2, n2);
                    ++n3;
                }
                this.Encoder.writeEnd(this.Info);
            }
            catch (PNGException pNGException) {
                this.EncodeException = pNGException;
            }
            catch (IOException iOException) {
                this.OutputException = iOException;
            }
            catch (Exception exception) {
                this.EncodeException = new PNGException(exception.toString());
            }
        } else {
            this.EncodeException = new PNGException("Null image");
        }
        this.encodeDone();
    }

    protected synchronized void encodeDone() {
        this.InProgress = false;
        this.notify();
    }
}

