/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.png;

import com.visualtek.png.PNGException;
import com.visualtek.png.PNGProducer;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public class PNGDecoder
implements ImageObserver {
    public static final int IMAGE_IS_NOT_READY = 0;
    public static final int IMAGE_OK = 1;
    public static final int IMAGE_ERROR = 2;
    private int Flags;
    private PNGProducer Producer;
    private InputStream In;
    private boolean CloseIn;

    public PNGDecoder(String string) throws IOException, FileNotFoundException {
        this(new FileInputStream(string));
        this.CloseIn = true;
    }

    public PNGDecoder(URL uRL) throws IOException {
        this(uRL.openStream());
        this.CloseIn = true;
    }

    public PNGDecoder(InputStream inputStream) throws IOException {
        this.In = inputStream;
        this.CloseIn = false;
        this.Producer = new PNGProducer(inputStream);
    }

    public Image decode() throws PNGException, IOException {
        Image image;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (!toolkit.prepareImage(image = toolkit.createImage(this.Producer), -1, -1, this)) {
            while (this.status() == 0) {
                try {
                    PNGDecoder pNGDecoder = this;
                    synchronized (pNGDecoder) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.status() == 2) {
            throw new PNGException("Error image loading");
        }
        if (this.CloseIn && this.In != null) {
            this.In.close();
        }
        return image;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        boolean bl;
        this.Flags = n;
        boolean bl2 = bl = this.status() == 0;
        if (!bl) {
            PNGDecoder pNGDecoder = this;
            synchronized (pNGDecoder) {
                this.notify();
            }
        }
        return bl;
    }

    public int status() {
        if ((this.Flags & 0x40) != 0) {
            return 2;
        }
        if ((this.Flags & 0x20) != 0) {
            return 1;
        }
        return 0;
    }
}

