/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.png;

import com.visualtek.png.PNGColorRowHandler;
import com.visualtek.png.PNGData;
import com.visualtek.png.PNGException;
import com.visualtek.png.PNGGrayRowHandler;
import com.visualtek.png.PNGInfo;
import com.visualtek.png.PNGRowHandler;
import com.visualtek.png.PNGTrueColorRowHandler;
import java.awt.Color;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

class PNGDataDecoder
extends PNGData {
    private DataInputStream istream;
    private Inflater zstream;

    public PNGDataDecoder(InputStream inputStream) {
        this.istream = new DataInputStream(inputStream);
        this.zstream = new Inflater();
        this.zbuf_size = 8192;
        this.zbuf = new byte[this.zbuf_size];
    }

    PNGInfo readInfo() throws PNGException, IOException {
        PNGInfo pNGInfo = new PNGInfo();
        this.istream.readFully(pNGInfo.signature, 0, 8);
        if (!this.memCompare(pNGInfo.signature, PNGData.png_sig, 8)) {
            throw new PNGException("Not a PNG file");
        }
        while (true) {
            int n = this.istream.readInt();
            this.resetCRC();
            this.crcRead(this.chunk_name, 4);
            if (this.memCompare(this.chunk_name, PNGData.png_IHDR, 4)) {
                this.handleIHDR(pNGInfo, n);
                if (pNGInfo.color_type == 0 || pNGInfo.color_type == 4) {
                    this.row_info = new PNGGrayRowHandler(pNGInfo);
                    continue;
                }
                if ((pNGInfo.color_type & 3) == 3) {
                    this.row_info = new PNGColorRowHandler(pNGInfo);
                    continue;
                }
                if ((pNGInfo.color_type & 2) == 2) {
                    this.row_info = new PNGTrueColorRowHandler(pNGInfo);
                    continue;
                }
                throw new PNGException("Not supported color type = " + pNGInfo.color_type);
            }
            if (this.memCompare(this.chunk_name, PNGData.png_PLTE, 4)) {
                this.handlePLTE(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IEND, 4)) {
                this.handleIEND(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4)) {
                if ((this.mode & 1) == 0) {
                    throw new PNGException("Missing IHDR before IDAT");
                }
                if (this.color_type == 3 && (this.mode & 2) == 0) {
                    throw new PNGException("Missing PLTE before IDAT");
                }
                this.idat_size = n;
                this.mode |= 4;
                break;
            }
            this.handleUnknown(pNGInfo, n);
        }
        return pNGInfo;
    }

    void readRow(byte[] byArray, int n) throws PNGException, IOException {
        if ((this.mode & 4) == 0) {
            throw new PNGException("Invalid attempt to read row data");
        }
        int n2 = this.irowbytes;
        int n3 = 0;
        do {
            int n4;
            if (this.zstream.needsInput()) {
                while (this.idat_size == 0) {
                    this.crcFinish(0);
                    this.idat_size = this.istream.readInt();
                    this.resetCRC();
                    this.crcRead(this.chunk_name, 4);
                    if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4)) continue;
                    throw new PNGException("Not enough image data");
                }
                int n5 = this.zbuf_size;
                if (this.zbuf_size > this.idat_size) {
                    n5 = this.idat_size;
                }
                this.crcRead(this.zbuf, n5);
                this.idat_size -= n5;
                this.zstream.setInput(this.zbuf, 0, n5);
            }
            try {
                n4 = this.zstream.inflate(this.row_buf, n3, n2);
            }
            catch (DataFormatException dataFormatException) {
                throw new PNGException("Zip error: " + dataFormatException.getMessage());
            }
            n3 += n4;
            n2 -= n4;
            if (!this.zstream.finished()) continue;
            if (this.zstream.getRemaining() != 0 || this.idat_size != 0) {
                throw new PNGException("Extra compressed data");
            }
            this.mode |= 8;
            this.flags |= 0x20;
            break;
        } while (n2 > 0);
        this.row_info.color_type = this.color_type;
        this.row_info.width = this.iwidth;
        this.row_info.channels = this.channels;
        this.row_info.bit_depth = this.bit_depth;
        this.row_info.pixel_depth = this.pixel_depth;
        this.row_info.rowbytes = this.row_info.width * this.row_info.pixel_depth + 7 >> 3;
        this.readFilterRow(this.row_info, this.row_buf, 1, this.prev_row, 1, this.row_buf[0] & 0xFF);
        System.arraycopy(this.row_buf, 0, this.prev_row, 0, this.rowbytes + 1);
        System.arraycopy(this.row_buf, 1, byArray, n, this.width * this.row_info.pixel_depth + 7 >> 3);
        ++this.row_number;
        if (this.row_number >= this.num_rows) {
            this.readFinishRow();
        }
    }

    PNGInfo readEnd() throws PNGException, IOException {
        PNGInfo pNGInfo = new PNGInfo();
        this.crcFinish(0);
        do {
            int n = this.istream.readInt();
            this.resetCRC();
            this.crcRead(this.chunk_name, 4);
            if (this.memCompare(this.chunk_name, PNGData.png_IHDR, 4)) {
                this.handleIHDR(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_PLTE, 4)) {
                this.handlePLTE(pNGInfo, n);
                continue;
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4)) {
                if (n <= 0 && (this.mode & 8) == 0) continue;
                throw new PNGException("Too many IDAT's found");
            }
            if (this.memCompare(this.chunk_name, PNGData.png_IEND, 4)) {
                this.handleIEND(pNGInfo, n);
                continue;
            }
            this.handleUnknown(pNGInfo, n);
        } while ((this.mode & 0x10) == 0);
        return pNGInfo;
    }

    private void handleIHDR(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        byte[] byArray = new byte[13];
        if (this.mode != 0) {
            throw new PNGException("Out of place IHDR");
        }
        if (n != 13) {
            throw new PNGException("Invalid IHDR chunk");
        }
        this.mode |= 1;
        this.crcRead(byArray, 13);
        this.crcFinish(0);
        this.width = this.getInt32(byArray);
        this.height = this.getInt32(byArray, 4);
        this.bit_depth = byArray[8];
        this.color_type = byArray[9];
        byte by = byArray[10];
        byte by2 = byArray[11];
        byte by3 = byArray[12];
        if (this.width == 0 || this.width > Integer.MAX_VALUE || this.height == 0 || this.height > Integer.MAX_VALUE) {
            throw new PNGException("Invalid image size in IHDR");
        }
        if (this.bit_depth != 1 && this.bit_depth != 2 && this.bit_depth != 4 && this.bit_depth != 8 && this.bit_depth != 16) {
            throw new PNGException("Invalid bit depth in IHDR");
        }
        if (this.color_type < 0 || this.color_type == 1 || this.color_type == 5 || this.color_type > 6) {
            throw new PNGException("Invalid color type in IHDR");
        }
        if (this.color_type == 3 && this.bit_depth > 8 || (this.color_type == 2 || this.color_type == 4 || this.color_type == 6) && this.bit_depth < 8) {
            throw new PNGException("Invalid color type/bit depth combination in IHDR");
        }
        if (by3 > 1) {
            throw new PNGException("Unknown interlace method in IHDR");
        }
        if (by > 0) {
            throw new PNGException("Unknown compression method in IHDR");
        }
        if (by2 > 0) {
            throw new PNGException("Unknown filter method in IHDR");
        }
        switch (this.color_type) {
            case 0: 
            case 3: {
                this.channels = 1;
                break;
            }
            case 2: {
                this.channels = (byte)3;
                break;
            }
            case 4: {
                this.channels = (byte)2;
                break;
            }
            case 6: {
                this.channels = (byte)4;
                break;
            }
        }
        this.pixel_depth = (byte)(this.bit_depth * this.channels);
        this.rowbytes = this.width * this.pixel_depth + 7 >> 3;
        this.readIHDR(pNGInfo, this.width, this.height, this.bit_depth, this.color_type, by, by2, by3);
    }

    private void handlePLTE(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        if ((this.mode & 1) == 0) {
            throw new PNGException("Missing IHDR before PLTE");
        }
        if ((this.mode & 4) != 0) {
            this.warning("Invalid PLTE after IDAT");
            this.crcFinish(n);
            return;
        }
        if ((this.mode & 2) != 0) {
            throw new PNGException("Duplicate PLTE chunk");
        }
        this.mode |= 2;
        if (n % 3 != 0) {
            if (this.color_type != 3) {
                this.warning("Invalid palette chunk");
                this.crcFinish(n);
                return;
            }
            throw new PNGException("Invalid palette chunk");
        }
        int n2 = n / 3;
        this.palette = new Color[n2];
        this.flags |= 0x1000;
        byte[] byArray = new byte[3];
        int n3 = 0;
        while (n3 < n2) {
            this.crcRead(byArray, 3);
            this.palette[n3] = new Color(byArray[0] & 0xFF, byArray[1] & 0xFF, byArray[2] & 0xFF);
            ++n3;
        }
        if (this.color_type == 3) {
            if (this.crcFinish(0) != 0) {
                return;
            }
        } else if (this.crcError()) {
            String string = "CRC error in " + this.chunk_name;
            if ((this.flags & 0x100) == 0) {
                if ((this.flags & 0x200) != 0) {
                    throw new PNGException(string);
                }
                this.warning(string);
                return;
            }
            if ((this.flags & 0x200) == 0) {
                this.warning(string);
            }
        }
        this.num_palette = (short)n2;
        this.readPLTE(pNGInfo, this.palette, n2);
    }

    private void handleIEND(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        if ((this.mode & 1) == 0 || (this.mode & 4) == 0) {
            throw new PNGException("No image in file");
        }
        this.mode |= 0x18;
        if (n != 0) {
            this.warning("Incorrect IEND chunk length");
            this.crcFinish(n);
        }
    }

    private void handleUnknown(PNGInfo pNGInfo, int n) throws PNGException, IOException {
        this.checkChunkName(this.chunk_name);
        if ((this.chunk_name[0] & 0x20) == 0) {
            String string = "Unknown critical chunk " + this.chunk_name;
            throw new PNGException(string);
        }
        if ((this.mode & 4) != 0) {
            this.mode |= 8;
        }
        this.crcFinish(n);
    }

    private void checkChunkName(byte[] byArray) throws PNGException {
        if (byArray[0] < 41 || byArray[0] > 122 || byArray[0] > 90 && byArray[0] < 97 || byArray[1] < 41 || byArray[1] > 122 || byArray[1] > 90 && byArray[1] < 97 || byArray[2] < 41 || byArray[2] > 122 || byArray[2] > 90 && byArray[2] < 97 || byArray[3] < 41 || byArray[3] > 122 || byArray[3] > 90 && byArray[3] < 97) {
            throw new PNGException("Invalid chunk type");
        }
    }

    private void readIHDR(PNGInfo pNGInfo, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        pNGInfo.width = n;
        pNGInfo.height = n2;
        pNGInfo.bit_depth = (byte)n3;
        pNGInfo.color_type = (byte)n4;
        pNGInfo.compression_type = (byte)n5;
        pNGInfo.filter_type = (byte)n6;
        pNGInfo.interlace_type = (byte)n7;
        pNGInfo.channels = pNGInfo.color_type == 3 ? (byte)1 : ((pNGInfo.color_type & 2) != 0 ? (byte)3 : (byte)1);
        if ((pNGInfo.color_type & 4) != 0) {
            pNGInfo.channels = (byte)(pNGInfo.channels + 1);
        }
        pNGInfo.pixel_depth = (byte)(pNGInfo.channels * pNGInfo.bit_depth);
        pNGInfo.rowbytes = pNGInfo.width * pNGInfo.pixel_depth + 7 >> 3;
    }

    private void readPLTE(PNGInfo pNGInfo, Color[] colorArray, int n) {
        pNGInfo.palette = colorArray;
        pNGInfo.num_palette = (short)n;
        pNGInfo.valid |= 8;
    }

    void readStartRow() {
        if (this.interlaced != 0) {
            this.num_rows = (this.transformations & 2) == 0 ? (this.height + PNGData.png_pass_yinc[0] - 1 - PNGData.png_pass_ystart[0]) / PNGData.png_pass_yinc[0] : this.height;
            this.iwidth = (this.width + PNGData.png_pass_inc[this.pass] - 1 - PNGData.png_pass_start[this.pass]) / PNGData.png_pass_inc[this.pass];
            this.irowbytes = (this.iwidth * this.pixel_depth + 7 >> 3) + 1;
        } else {
            this.num_rows = this.height;
            this.iwidth = this.width;
            this.irowbytes = this.rowbytes + 1;
        }
        byte by = this.pixel_depth;
        int n = this.width + 7 & 0xFFFFFFF8;
        n = (n * by + 7 >> 3) + 1 + (by + 7 >> 3);
        this.row_buf = new byte[n];
        this.prev_row = new byte[this.rowbytes + 1];
        this.memSet(this.prev_row, 0, this.rowbytes + 1);
    }

    private void readFilterRow(PNGRowHandler pNGRowHandler, byte[] byArray, int n, byte[] byArray2, int n2, int n3) throws PNGException {
        switch (n3) {
            case 1: {
                int n4 = (this.pixel_depth + 7) / 8;
                int n5 = n + n4;
                int n6 = n;
                int n7 = n4;
                while (n7 < this.rowbytes) {
                    byArray[n5] = (byte)((byArray[n5] & 0xFF) + (byArray[n6++] & 0xFF) & 0xFF);
                    ++n5;
                    ++n7;
                }
                return;
            }
            case 2: {
                int n8 = n;
                int n9 = n2;
                int n10 = 0;
                while (n10 < this.rowbytes) {
                    byArray[n8] = (byte)((byArray[n8] & 0xFF) + (byArray2[n9++] & 0xFF) & 0xFF);
                    ++n8;
                    ++n10;
                }
                return;
            }
            case 3: {
                int n11 = (this.pixel_depth + 7) / 8;
                int n12 = n;
                int n13 = n2;
                int n14 = 0;
                while (n14 < n11) {
                    byArray[n12] = (byte)((byArray[n12] & 0xFF) + (byArray2[n13++] & 0xFF) / 2 & 0xFF);
                    ++n12;
                    ++n14;
                }
                int n15 = n;
                while (n14 < this.rowbytes) {
                    byArray[n12] = (byte)((byArray[n12] & 0xFF) + ((byArray2[n13++] & 0xFF) + (byArray[n15++] & 0xFF)) / 2 & 0xFF);
                    ++n12;
                    ++n14;
                }
                return;
            }
            case 4: {
                int n16 = (this.pixel_depth + 7) / 8;
                int n17 = 0;
                int n18 = -n16;
                while (n17 < this.rowbytes) {
                    int n19;
                    int n20;
                    int n21 = byArray2[n17 + n2] & 0xFF;
                    if (n17 >= n16) {
                        n20 = byArray2[n18 + n2] & 0xFF;
                        n19 = byArray[n18 + n] & 0xFF;
                    } else {
                        n20 = 0;
                        n19 = 0;
                    }
                    int n22 = n21 - n20;
                    int n23 = n19 - n20;
                    int n24 = n22 + n23;
                    if (n22 < 0) {
                        n22 = -n22;
                    }
                    if (n23 < 0) {
                        n23 = -n23;
                    }
                    if (n24 < 0) {
                        n24 = -n24;
                    }
                    int n25 = n22 <= n23 && n22 <= n24 ? n19 : (n23 <= n24 ? n21 : n20);
                    byArray[n17 + n] = (byte)((byArray[n17 + n] & 0xFF) + n25 & 0xFF);
                    ++n17;
                    ++n18;
                }
                return;
            }
            default: {
                throw new PNGException("Bad adaptive filter type");
            }
            case 0: 
        }
    }

    private void readFinishRow() throws PNGException, IOException {
        block13: {
            if (this.interlaced != 0) {
                this.row_number = 0;
                this.memSet(this.prev_row, 0, this.rowbytes + 1);
                do {
                    this.pass = (byte)(this.pass + 1);
                    if (this.pass >= 7) break;
                    this.iwidth = (this.width + PNGData.png_pass_inc[this.pass] - 1 - PNGData.png_pass_start[this.pass]) / PNGData.png_pass_inc[this.pass];
                    this.irowbytes = (this.iwidth * this.pixel_depth + 7 >> 3) + 1;
                    if ((this.transformations & 2) == 0) {
                        this.num_rows = (this.height + PNGData.png_pass_yinc[this.pass] - 1 - PNGData.png_pass_ystart[this.pass]) / PNGData.png_pass_yinc[this.pass];
                        if (this.num_rows == 0) continue;
                    }
                    if ((this.transformations & 2) != 0) break;
                } while (this.iwidth == 0);
                if (this.pass < 7) {
                    return;
                }
            }
            if ((this.flags & 0x20) == 0) {
                byte[] byArray = new byte[1];
                do {
                    if (this.zstream.needsInput()) {
                        while (this.idat_size == 0) {
                            this.crcFinish(0);
                            this.idat_size = this.istream.readInt();
                            this.resetCRC();
                            this.crcRead(this.chunk_name, 4);
                            if (this.memCompare(this.chunk_name, PNGData.png_IDAT, 4)) continue;
                            throw new PNGException("Not enough image data");
                        }
                        int n = this.zbuf_size;
                        if (this.zbuf_size > this.idat_size) {
                            n = this.idat_size;
                        }
                        this.crcRead(this.zbuf, n);
                        this.idat_size -= n;
                        this.zstream.setInput(this.zbuf, 0, n);
                    }
                    try {
                        this.zstream.inflate(byArray, 0, 1);
                    }
                    catch (DataFormatException dataFormatException) {
                        throw new PNGException("Zip error: " + dataFormatException.getMessage());
                    }
                    if (!this.zstream.finished()) continue;
                    if (this.zstream.getRemaining() != 0 || this.idat_size != 0) {
                        throw new PNGException("Extra compressed data");
                    }
                    this.mode |= 8;
                    this.flags |= 0x20;
                    break block13;
                } while (this.zstream.getRemaining() != 0);
                throw new PNGException("Extra compressed data");
            }
        }
        if (this.idat_size != 0 || this.zstream.getRemaining() != 0) {
            throw new PNGException("Extra compression data");
        }
        this.zstream.reset();
        this.mode |= 8;
    }

    private void crcRead(byte[] byArray, int n) throws IOException {
        boolean bl = true;
        bl = (this.chunk_name[0] & 0x20) != 0 ? (this.flags & 0x300) != 768 : (this.flags & 0x800) == 0;
        this.istream.readFully(byArray, 0, n);
        if (bl) {
            this.calculateCRC(byArray, n);
        }
    }

    private int crcFinish(int n) throws PNGException, IOException {
        boolean bl = true;
        if ((this.chunk_name[0] & 0x20) != 0) {
            if ((this.flags & 0x300) == 768) {
                bl = false;
            }
        } else if ((this.flags & 0x800) != 0) {
            bl = false;
        }
        int n2 = n;
        while (n2 > this.zbuf_size) {
            this.istream.readFully(this.zbuf, 0, this.zbuf_size);
            if (bl) {
                this.calculateCRC(this.zbuf, this.zbuf_size);
            }
            n2 -= this.zbuf_size;
        }
        if (n2 != 0) {
            this.istream.readFully(this.zbuf, 0, n2);
            if (bl) {
                this.calculateCRC(this.zbuf, n2);
            }
        }
        boolean bl2 = this.crcError();
        if (bl && bl2) {
            String string = "CRC error in " + this.chunk_name;
            if (!((this.chunk_name[0] & 0x20) != 0 && (this.flags & 0x200) == 0 || (this.chunk_name[0] & 0x20) == 0 && (this.flags & 0x400) != 0)) {
                throw new PNGException(string);
            }
            this.warning(string);
            return 1;
        }
        return 0;
    }

    private boolean crcError() throws IOException {
        return this.istream.readInt() != this.crc;
    }
}

