/*
 * Decompiled with CFR 0.152.
 */
package com.visualtek.png;

import com.visualtek.png.PNGException;
import com.visualtek.png.PNGInfo;
import com.visualtek.png.PNGRowHandler;

class PNGColorRowHandler
extends PNGRowHandler {
    PNGInfo info;
    int mask;

    private PNGColorRowHandler() {
    }

    PNGColorRowHandler(PNGInfo pNGInfo) throws PNGException {
        this.info = pNGInfo;
        this.mask = (1 << this.info.bit_depth) - 1;
        switch (this.info.bit_depth) {
            default: {
                throw new PNGException("Not supported number of bit per pixel = " + this.info.bit_depth);
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: 
        }
    }

    void transformRow(byte[] byArray, int n, int[] nArray, int n2) throws PNGException {
        int n3 = n;
        try {
            while (n3 < byArray.length) {
                int n4 = byArray[n3] & 0xFF;
                int n5 = 8 - this.info.bit_depth;
                while (n5 >= 0) {
                    int n6 = n4 >> n5 & this.mask;
                    int n7 = this.info.palette[n6].getRed();
                    int n8 = this.info.palette[n6].getGreen();
                    int n9 = this.info.palette[n6].getBlue();
                    nArray[n2++] = 0xFF000000 | n7 << 16 | n8 << 8 | n9;
                    n5 -= this.info.bit_depth;
                }
                ++n3;
            }
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }

    void transformRowBytes(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n) throws PNGException {
        int n2 = 0;
        try {
            while (n2 < byArray.length) {
                int n3 = byArray[n2] & 0xFF;
                int n4 = 8 - this.info.bit_depth;
                while (n4 >= 0) {
                    int n5 = n3 >> n4 & this.mask;
                    byArray2[n] = (byte)this.info.palette[n5].getRed();
                    byArray3[n] = (byte)this.info.palette[n5].getGreen();
                    byArray4[n] = (byte)this.info.palette[n5].getBlue();
                    ++n;
                    n4 -= this.info.bit_depth;
                }
                ++n2;
            }
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return;
        }
    }
}

