/*
 * Decompiled with CFR 0.152.
 */
package Acme.JPM.Decoders;

import Acme.JPM.Decoders.ImageDecoderRead;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public abstract class ImageDecoder
implements ImageProducer {
    private InputStream in;
    private int width;
    private int height;
    private boolean[] rowsRead;
    private int[][] rgbPixels;
    private boolean startedRead = false;
    private boolean gotSize = false;
    private boolean err = false;
    private boolean producing = false;
    private Vector consumers = new Vector();
    private static final ColorModel model = ColorModel.getRGBdefault();

    public ImageDecoder(InputStream in) {
        this.in = in;
    }

    abstract void readHeader(InputStream var1) throws IOException;

    abstract int getWidth();

    abstract int getHeight();

    abstract void readRow(InputStream var1, int var2, int[] var3) throws IOException;

    void readImage() {
        try {
            this.readHeader(this.in);
            this.width = this.getWidth();
            this.height = this.getHeight();
            if (this.width == -1 || this.height == -1) {
                this.err = true;
            } else {
                int row;
                this.rowsRead = new boolean[this.height];
                for (row = 0; row < this.height; ++row) {
                    this.rowsRead[row] = false;
                }
                this.gotSize = true;
                this.notifyThem();
                this.rgbPixels = new int[this.height][this.width];
                for (row = 0; row < this.height; ++row) {
                    this.readRow(this.in, row, this.rgbPixels[row]);
                    this.rowsRead[row] = true;
                    this.notifyThem();
                }
            }
        }
        catch (IOException e) {
            this.err = true;
            this.width = -1;
            this.height = -1;
            this.rowsRead = null;
            this.rgbPixels = null;
        }
    }

    private synchronized void notifyThem() {
        this.notifyAll();
    }

    void sendImage() {
        int i;
        ImageConsumer[] c = new ImageConsumer[this.consumers.size()];
        for (i = 0; i < c.length; ++i) {
            c[i] = (ImageConsumer)this.consumers.elementAt(i);
        }
        this.waitForSize();
        for (i = 0; i < c.length; ++i) {
            this.sendHead(c[i]);
        }
        for (int row = 0; row < this.height; ++row) {
            for (i = 0; i < c.length; ++i) {
                this.sendPixelRow(c[i], row);
            }
        }
        for (i = 0; i < c.length; ++i) {
            this.sendTail(c[i]);
        }
        this.producing = false;
    }

    private synchronized void waitForSize() {
        while (!this.err && !this.gotSize) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void waitForRow(int row) {
        while (!this.err && !this.rowsRead[row]) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void sendHead(ImageConsumer ic) {
        if (this.err) {
            return;
        }
        ic.setDimensions(this.width, this.height);
        ic.setColorModel(model);
        ic.setHints(30);
    }

    private void sendPixelRow(ImageConsumer ic, int row) {
        if (this.err) {
            return;
        }
        this.waitForRow(row);
        if (this.err) {
            return;
        }
        ic.setPixels(0, row, this.width, 1, model, this.rgbPixels[row], 0, this.width);
    }

    private void sendTail(ImageConsumer ic) {
        if (this.err) {
            ic.imageComplete(1);
        } else {
            ic.imageComplete(3);
        }
    }

    public void addConsumer(ImageConsumer ic) {
        if (ic != null && !this.isConsumer(ic)) {
            this.consumers.addElement(ic);
        }
    }

    public boolean isConsumer(ImageConsumer ic) {
        return this.consumers.contains(ic);
    }

    public void removeConsumer(ImageConsumer ic) {
        this.consumers.removeElement(ic);
    }

    public void startProduction(ImageConsumer ic) {
        this.addConsumer(ic);
        if (!this.startedRead) {
            this.startedRead = true;
            new ImageDecoderRead(this);
        }
        if (!this.producing) {
            this.producing = true;
            this.sendImage();
        }
    }

    public void requestTopDownLeftRightResend(ImageConsumer ic) {
        this.addConsumer(ic);
        this.waitForSize();
        this.sendHead(ic);
        for (int row = 0; row < this.height; ++row) {
            this.sendPixelRow(ic, row);
        }
        this.sendTail(ic);
    }
}

