/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

public class Pco2FileFormat {
    private String[][] COLUMNS = new String[][]{{"pco2", "temp", "water"}, {"pco2", "mv", "temp", "pressure"}};
    private String[][] UNITS = new String[][]{{"parts per million", "degrees Celsius", "millivolts"}, {"parts per million", "millivolts", "degrees Celsius", "kilopascals"}};
    private String[][] LONG_NAME = new String[][]{{"pCO2", "sensor internal temperature", "water sensor alarm"}, {"pCO2", "sensor output voltage", "sensor internal temperature", "sensor internal pressure"}};
    private int fileFormat;
    public static final int OLD_6_COLUMN = 0;
    public static final int NEW_7_COLUMN = 1;

    public Pco2FileFormat(int fileFormat) {
        this.fileFormat = fileFormat;
    }

    public int getMinNumColumns() {
        return this.COLUMNS[this.fileFormat].length + 2;
    }

    public int getMaxNumColumns() {
        return this.COLUMNS[this.fileFormat].length + 3;
    }

    public String[] getColumnNames() {
        return this.COLUMNS[this.fileFormat];
    }

    public String[] getUnits() {
        return this.UNITS[this.fileFormat];
    }

    public String[] getLongName() {
        return this.LONG_NAME[this.fileFormat];
    }

    static {
        OLD_6_COLUMN = 0;
        NEW_7_COLUMN = 1;
    }
}

