/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.Properties;
import org.mbari.hobilabs.HSDPacket;
import org.mbari.hobilabs.HSDParser;

public class OasisHS2Parser {
    private File inFile;
    private Writer out;
    private Properties cal;
    private NumberFormat nf = NumberFormat.getNumberInstance();

    public OasisHS2Parser(File inFile_, Writer out_, Properties cal_) {
        this.inFile = inFile_;
        this.out = out_;
        this.cal = cal_;
        this.nf.setMaximumFractionDigits(8);
        this.nf.setMinimumFractionDigits(8);
        this.nf.setMinimumIntegerDigits(1);
        this.parse();
    }

    private void parse() {
        try {
            String s;
            BufferedReader in = new BufferedReader(new FileReader(this.inFile));
            while ((s = in.readLine()) != null) {
                if (!s.startsWith("*D")) continue;
                try {
                    HSDPacket p = HSDParser.parse((String)s);
                    this.calibrate(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    System.out.println("Invalid string");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void calibrate(HSDPacket p) throws IOException {
        boolean newLine = true;
        for (int i = 0; i < 8; ++i) {
            if (p.getGain(i) == 0) continue;
            int j = i + 1;
            double T = (double)p.getTemperature() / 5.0 - 10.0;
            double Tc = 0.0;
            try {
                Tc = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".TempCoeff")))));
            }
            catch (Exception e) {
                System.out.println(j);
            }
            double Tn = Double.parseDouble(this.cal.getProperty("TempNom"));
            double mu = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".Mu")))));
            double beta = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".Beta2Bb")))));
            double gain = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".Gain").append(p.getGain(i))))));
            double Rn = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".RNominal")))));
            double bbu = (1.0 - Tc * T / Tn) * mu * beta * (double)p.getSnorm(i) / (gain * Rn);
            double B = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".Bb2c")))));
            double c = bbu * B;
            double sigma1 = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".Sigma1")))));
            double sigma2 = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".Sigma2")))));
            double sigma3 = Double.parseDouble(this.cal.getProperty(String.valueOf(String.valueOf(new StringBuffer("Channel").append(j).append(".Sigma3")))));
            double sigmaC = sigma1 + sigma2 * c + sigma3 * Math.pow(c, 2.0);
            double bb = bbu * sigmaC;
            if (newLine) {
                this.out.write(String.valueOf(String.valueOf(p.getTime() / (long)1000)).concat(""));
                newLine = false;
            }
            this.out.write("\t".concat(String.valueOf(String.valueOf(this.nf.format(bb)))));
        }
        this.out.write("\n");
    }
}

