/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.File;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.StringTokenizer;

public class OasisExtractor {
    private File home;
    private File cfg;
    private String can;
    private int start;
    private int end;

    public OasisExtractor(String cfg_, String home_, int start_, int end_) {
        this.cfg = new File(cfg_);
        this.home = new File(home_);
        this.start = start_;
        this.end = end_;
    }

    public void start() {
        Runtime rt = Runtime.getRuntime();
        StringTokenizer st = new StringTokenizer(this.cfg.getName());
        String can = st.nextToken(".");
        String cfgP = this.cfg.getAbsolutePath();
        String filePath = this.home.getAbsolutePath();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumIntegerDigits(2);
        nf.setMaximumIntegerDigits(2);
        nf.setMaximumFractionDigits(0);
        for (int date = this.start; date <= this.end; ++date) {
            for (int hour = 0; hour < 24; ++hour) {
                String hourS = nf.format(hour);
                System.out.println(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(can))).append(".").append(date).append(".").append(hourS).append(": "))));
                try {
                    rt.exec(String.valueOf(String.valueOf(new StringBuffer("nice /oasis/bin/extract -y 1 -i specprr -c ").append(cfgP).append(" ").append(filePath).append("/").append(can).append(".").append(date).append(".").append(hourS))));
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void main(String[] args) {
        switch (args.length) {
            case 4: {
                OasisExtractor oasisExtractor1 = new OasisExtractor(args[0], args[1], Integer.parseInt(args[2]), Integer.parseInt(args[3]));
                oasisExtractor1.start();
                break;
            }
            default: {
                System.out.println("\n Use as:java OasisExtractor cfgFile directory startDate endDate");
            }
        }
    }
}

