/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.File;
import java.text.Collator;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Locale;
import org.mbari.oasis.OMSSensor;
import org.mbari.util.DateConverter;

public class OMSUtil {
    private OMSUtil() {
    }

    public static String getLongName(String name) {
        String longName = (name = name.toLowerCase()).startsWith("ed") ? String.valueOf(String.valueOf(new StringBuffer("Downwelled irradiance at ").append(name.substring(2)).append(" nm"))) : (name.equals("fluor") ? "Fluorescence" : (name.equals("gnd") ? "Ground voltage" : (name.startsWith("lu") ? String.valueOf(String.valueOf(new StringBuffer("Upwelled radiance at ").append(name.substring(2)).append(" nm"))) : (name.equals("mcp") ? "Downwelled irradiance at 490 nm" : (name.equals("par") ? "Downwelled photosynthetically active radiation" : (name.equals("pitch") ? "Pitch" : (name.equals("roll") ? "Roll" : (name.equals("temp") ? "Temperature" : (name.equals("latitude") ? "Latitude" : (name.equals("longitude") ? "Longitude" : (name.equals("bankdepth") ? "Depths of the instruments by bank" : "null")))))))))));
        return longName;
    }

    public static String getUniqueName(String name, int bank, int channel) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(name))).append("_").append(bank).append("_").append(channel)));
    }

    public static String getUniqueName(OMSSensor s) {
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(s.getName()))).append("_").append(s.getBank()).append("_").append(s.getChannel())));
    }

    public static String getSortableName(OMSSensor s) {
        DecimalFormat df = new DecimalFormat("00");
        return String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(df.format(s.getBank())))).append("_").append(df.format(s.getChannel())).append("_").append(s.getName())));
    }

    public static Date getDateFromName(String filename) {
        String name = new File(filename).getName();
        return DateConverter.doyToDate((int)OMSUtil.getDay(name), (int)OMSUtil.getYear(name));
    }

    public static int getYear(String filename) {
        String name = new File(filename).getName();
        if (name.length() == 5) {
            char[] buf = new char[2];
            name.getChars(0, 2, buf, 0);
            String Year = new String(buf);
            return Integer.parseInt(Year) + 1900;
        }
        if (name.length() == 7) {
            char[] buf = new char[4];
            name.getChars(0, 4, buf, 0);
            String Year = new String(buf);
            return Integer.parseInt(Year);
        }
        return 0;
    }

    public static int getDay(String filename) {
        String name = new File(filename).getName();
        if (name.length() == 5) {
            char[] buf = new char[3];
            name.getChars(2, 5, buf, 0);
            String Day = new String(buf);
            return Integer.parseInt(Day);
        }
        if (name.length() == 7) {
            char[] buf = new char[3];
            name.getChars(4, 7, buf, 0);
            String Day = new String(buf);
            return Integer.parseInt(Day);
        }
        return 0;
    }

    public static String[] sortFiles(String[] strArray) {
        Locale locale = Locale.US;
        Collator collator = Collator.getInstance(locale);
        for (int i = 0; i < strArray.length; ++i) {
            for (int j = i + 1; j < strArray.length; ++j) {
                if (collator.compare(strArray[i], strArray[j]) <= 0) continue;
                String tmp = strArray[i];
                strArray[i] = strArray[j];
                strArray[j] = tmp;
            }
        }
        return strArray;
    }

    public static float getWavelength(OMSSensor s) {
        return OMSUtil.getWavelength(s.getName());
    }

    public static float getWavelength(String name) {
        float lambda = -999.0f;
        if ((name = name.toLowerCase()).startsWith("ed")) {
            lambda = Float.parseFloat(name.substring(2));
        } else if (name.startsWith("lu")) {
            lambda = Float.parseFloat(name.substring(2));
        } else if (name.equals("mcp")) {
            lambda = 490.0f;
        }
        return lambda;
    }

    public static String getDataSymbol(OMSSensor s) {
        String symbol;
        String name = s.getName().toLowerCase();
        if (name.startsWith("ed")) {
            switch (s.getBank()) {
                case 0: {
                    symbol = "Es";
                    break;
                }
                default: {
                    symbol = "Ed";
                    break;
                }
            }
        } else {
            symbol = name.equals("fluor") ? "F" : (name.equals("gnd") ? "V" : (name.startsWith("lu") ? "Lu" : (name.equals("mcp") ? "Ed" : (name.equals("par") ? "PAR" : (name.equals("pitch") ? "null" : (name.equals("roll") ? "null" : (name.equals("temp") ? "T" : (name.equals("latitude") ? "Lat" : (name.equals("longitude") ? "Lon" : (name.equals("bankDepth") ? "Z" : (name.startsWith("depth") ? "Z" : "null")))))))))));
        }
        return symbol;
    }
}

