/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.mbari.io.FlatFileReader;
import org.mbari.oasis.OMSConfigReader;
import org.mbari.oasis.OMSSensor;
import org.mbari.oasis.OMSUtil;
import org.mbari.util.DateConverter;
import ucar.netcdf.NetcdfFile;
import ucar.netcdf.Variable;

public class OMSNetcdfAppender {
    boolean DEBUG = true;
    String file;
    String cfg;
    NetcdfFile nc;
    double[] time;
    double[][] data;

    public OMSNetcdfAppender(String cfgfile, String filename, String ncfile) throws IOException {
        this.file = filename;
        this.nc = new NetcdfFile(ncfile, false);
        this.cfg = cfgfile;
        this.process();
        this.nc.close();
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.out.println();
            System.out.println("Usage: org.mbari.netcdf.OMSNetcdfAppender configfile datafile ncfile clobber");
            System.out.println();
            System.out.println("Inputs: configfile = name of the mooring configuration file");
            System.out.println("        datafile   = name of specprr data file");
            System.out.println("        ncfile     = name of netcdf file to be created");
            System.out.println();
        } else if (args.length == 3) {
            try {
                File nc = new File(args[2]);
                if (nc.exists()) {
                    OMSNetcdfAppender oMSNetcdfAppender = new OMSNetcdfAppender(args[0], args[1], args[2]);
                } else {
                    System.out.println(String.valueOf(String.valueOf(args[2])).concat(" does not exist. Program aborted"));
                }
            }
            catch (IOException e) {
                System.out.println("Unable to read or create one of the input files");
            }
        }
    }

    private void process() throws IOException {
        Date fileDate = OMSUtil.getDateFromName(this.file);
        Date lastNcDate = new Date(DateConverter.serialDaysToUtc((double)1.0));
        Variable timeV = this.nc.get("time");
        int[] extent = timeV.getLengths();
        int n = extent[0];
        int[] lastRec = new int[]{n - 1};
        if (n > 0 && timeV.getDouble(lastRec) > 0.0) {
            lastNcDate = new Date((long)timeV.getDouble(lastRec) * (long)1000);
        }
        if (fileDate.after(lastNcDate)) {
            this.msg("Reading :".concat(String.valueOf(String.valueOf(this.file))));
            FlatFileReader ffr = new FlatFileReader(this.file);
            ffr.readFile();
            this.data = ffr.getData();
            int Year = OMSUtil.getYear(this.file);
            this.time = new double[ffr.countRows()];
            for (int j = 0; j < ffr.countRows(); ++j) {
                this.time[j] = (double)DateConverter.doyToDate((double)this.data[j][0], (int)Year).getTime() / (double)1000;
            }
            OMSConfigReader cr = new OMSConfigReader(this.cfg, Double.parseDouble(new File(this.file).getName()));
            for (int r = 0; r < ffr.countRows(); ++r) {
                int[] ti = timeV.getLengths();
                timeV.setDouble(ti, this.time[r]);
                for (int c = 0; c < cr.countChannels(); ++c) {
                    OMSSensor s = cr.getConfiguration(c);
                    String varName = OMSUtil.getUniqueName(s);
                    Variable v = this.nc.get(varName);
                    if (v == null) continue;
                    v.setFloat(ti, (float)this.data[r][c + 1]);
                }
            }
        }
    }

    private void msg(String s) {
        if (this.DEBUG) {
            System.out.println("OMSNetcdfAppender: ".concat(String.valueOf(String.valueOf(s))));
        }
    }
}

