/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.oasis;

import java.io.File;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.mbari.oasis.OMSAttributeReader;
import org.mbari.oasis.OMSSensor;
import org.mbari.oasis.OMSUtil;
import org.mbari.oasis.OMSVariable;
import org.mbari.oasis.OMSVariableReader;
import ucar.netcdf.Attribute;
import ucar.netcdf.Dimension;
import ucar.netcdf.ProtoVariable;
import ucar.netcdf.Schema;
import ucar.netcdf.UnlimitedDimension;

public abstract class OMSAbstractSchemaConstructor {
    protected OMSVariable[] variables;
    protected Schema schema;
    protected File cfgfile;
    protected Dimension timeD = new UnlimitedDimension("time");
    protected ProtoVariable[] axesP;

    public OMSAbstractSchemaConstructor(File file) {
        this.cfgfile = file;
        this.init();
    }

    public Schema getSchema() {
        return this.schema;
    }

    public ProtoVariable[] getAxes() {
        return this.axesP;
    }

    private void init() {
        this.schema = new Schema();
        OMSAttributeReader ar = new OMSAttributeReader(this.cfgfile);
        this.setGlobalAttributes(this.createGlobalAttributes(ar));
        OMSVariableReader vr = new OMSVariableReader(this.cfgfile);
        this.setAxes(vr);
        this.variables = vr.getVariables();
        OMSSensor[] s = this.getSensors();
        ProtoVariable[] pv = this.setAttributes(s);
        this.setProtoVariables(pv);
    }

    private void setGlobalAttributes(Attribute[] att) {
        for (int i = 0; i < Array.getLength(att); ++i) {
            this.schema.putAttribute(att[i]);
        }
    }

    private Attribute[] createGlobalAttributes(OMSAttributeReader ar) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        int i = 3;
        Attribute[] att = new Attribute[i + ar.countAttributes()];
        att[0] = new Attribute("conventions", "MBARI/timeSeries/mooring/spectroradiometer");
        att[1] = new Attribute("creationDate", sdf.format(new Date()));
        att[2] = new Attribute("lastModified", sdf.format(new Date()));
        sdf = null;
        while (ar.hasMoreElements()) {
            att[i] = (Attribute)ar.nextElement();
            ++i;
        }
        return att;
    }

    private void setAxes(OMSVariableReader vr) {
        this.axesP = new ProtoVariable[1 + vr.countVariables()];
        this.axesP[0] = new ProtoVariable("time", Double.TYPE, this.timeD);
        this.axesP[0].putAttribute(new Attribute("long_name", "time GMT"));
        this.axesP[0].putAttribute(new Attribute("units", "seconds since 1970-01-01 00:00:00"));
        OMSVariable[] v = vr.getVariables();
        for (int i = 1; i < vr.countVariables() + 1; ++i) {
            String units;
            int j = i - 1;
            this.axesP[i] = new ProtoVariable(v[j].getName(), Double.TYPE, new Dimension(v[j].getName(), v[j].countVariables()));
            this.axesP[i].putAttribute(new Attribute("long_name", OMSUtil.getLongName(v[j].getName())));
            String vn = v[j].getName().toLowerCase();
            if (vn.equals("longitude")) {
                units = "degrees_east";
            } else if (vn.equals("latitude")) {
                units = "degrees_north";
            } else if (vn.equals("bankdepth")) {
                units = "meters";
                this.axesP[i].putAttribute(new Attribute("positive", "down"));
            } else {
                units = "";
            }
            this.axesP[i].putAttribute(new Attribute("units", units));
        }
        this.setProtoVariables(this.axesP);
    }

    private void setProtoVariables(ProtoVariable[] pv) {
        for (int i = 0; i < Array.getLength(pv); ++i) {
            this.schema.put(pv[i]);
        }
    }

    private void setProtoVariables(ProtoVariable pv) {
        this.schema.put(pv);
    }

    private Attribute[] createAttributes(OMSSensor sensor) {
        float depth = -999.0f;
        block8: for (int i = 0; i < this.variables.length; ++i) {
            if (!this.variables[i].getName().equalsIgnoreCase("bankDepth")) continue;
            float[] depths = this.variables[i].getValues();
            depth = depths[sensor.getBank()];
            if (sensor.getBank() != 2) continue;
            switch (sensor.getChannel()) {
                case 11: {
                    depth -= 10.0f;
                    continue block8;
                }
                case 12: {
                    depth -= 10.0f;
                    continue block8;
                }
                case 13: {
                    depth -= 10.0f;
                    continue block8;
                }
                case 14: {
                    depth -= 10.0f;
                    continue block8;
                }
                case 15: {
                    depth += 10.0f;
                    continue block8;
                }
                case 16: {
                    depth += 10.0f;
                }
            }
        }
        String symbol = OMSUtil.getDataSymbol(sensor);
        float waveLength = OMSUtil.getWavelength(sensor);
        int length = 6;
        return new Attribute[]{new Attribute("long_name", OMSUtil.getLongName(sensor.getName())), new Attribute("units", sensor.getUnits()), new Attribute("bank", (double)sensor.getBank()), new Attribute("channel", (double)sensor.getChannel()), new Attribute("instrumentDepth", (double)depth), new Attribute("symbol", symbol), new Attribute("wavelength", (double)waveLength), new Attribute("_FillValue", (Number)new Float(-999.0f)), new Attribute("missing_value", (Number)new Float(-999.0f))};
    }

    private ProtoVariable[] setAttributes(OMSSensor[] s) {
        ProtoVariable[] pv = new ProtoVariable[s.length];
        int k = 0;
        for (int i = 0; i < s.length; ++i) {
            if (s[i].getType() == 0) continue;
            pv[k] = new ProtoVariable(OMSUtil.getUniqueName(s[i]), Float.TYPE, this.timeD);
            Attribute[] att = this.createAttributes(s[i]);
            for (int j = 0; j < Array.getLength(att); ++j) {
                pv[k].putAttribute(att[j]);
            }
            ++k;
        }
        return pv;
    }

    protected abstract OMSSensor[] getSensors();
}

