/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.visad.tutorial;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.rmi.RemoteException;
import javax.swing.JFrame;
import visad.ConstantMap;
import visad.Data;
import visad.DataReference;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FlatField;
import visad.FunctionType;
import visad.GraphicsModeControl;
import visad.Integer1DSet;
import visad.Linear1DSet;
import visad.MathType;
import visad.RangeControl;
import visad.RealTupleType;
import visad.RealType;
import visad.SI;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Set;
import visad.Unit;
import visad.VisADException;
import visad.java2d.DisplayImplJ2D;

public class P2_05 {
    private RealType time = new RealType("time", (Unit)SI.second, null);
    private RealType height = new RealType("height", (Unit)SI.meter, null);
    private RealType index;
    private RealTupleType t_h_tuple = new RealTupleType(this.time, this.height);
    private FunctionType func_i_tuple;
    private FunctionType func_time_height;
    private Set time_set;
    private Set index_set;
    private FlatField line_ff;
    private FlatField points_ff;
    private DataReferenceImpl points_ref;
    private DataReferenceImpl line_ref;
    private DisplayImpl display;
    private ScalarMap timeMap;
    private ScalarMap heightMap;
    private ScalarMap timeRangeMap;

    public P2_05(String[] args) throws VisADException, RemoteException {
        this.index = new RealType("index");
        this.func_i_tuple = new FunctionType((MathType)this.index, (MathType)this.t_h_tuple);
        this.index_set = new Integer1DSet((MathType)this.index, 5);
        float[][] point_vals = new float[][]{{-3.0f, -1.5f, 0.0f, 1.5f, 3.0f}, {0.0f, 33.75f, 45.0f, 33.75f, 0.0f}};
        this.points_ff = new FlatField(this.func_i_tuple, this.index_set);
        this.points_ff.setSamples((float[][])point_vals);
        this.func_time_height = new FunctionType((MathType)this.time, (MathType)this.height);
        int LENGTH = 25;
        this.time_set = new Linear1DSet((MathType)this.time, -3.0, 3.0, LENGTH);
        float[][] h_vals = new float[1][LENGTH];
        float[][] d_vals = this.time_set.getSamples(true);
        for (int i = 0; i < LENGTH; ++i) {
            h_vals[0][i] = 45.0f - 5.0f * (d_vals[0][i] * d_vals[0][i]);
        }
        this.line_ff = new FlatField(this.func_time_height, this.time_set);
        this.line_ff.setSamples(h_vals);
        this.display = new DisplayImplJ2D("display1");
        GraphicsModeControl dispGMC = this.display.getGraphicsModeControl();
        dispGMC.setScaleEnable(true);
        this.timeMap = new ScalarMap((ScalarType)this.time, Display.XAxis);
        this.heightMap = new ScalarMap((ScalarType)this.height, Display.YAxis);
        this.timeRangeMap = new ScalarMap((ScalarType)this.time, Display.SelectRange);
        this.display.addMap(this.timeMap);
        this.display.addMap(this.heightMap);
        this.display.addMap(this.timeRangeMap);
        this.timeMap.setRange(-4.0, 4.0);
        this.heightMap.setRange(-10.0, 50.0);
        RangeControl timeRangeControl = (RangeControl)this.timeRangeMap.getControl();
        float[] timeRange = new float[]{-2.0f, 4.0f};
        timeRangeControl.setRange(timeRange);
        this.points_ref = new DataReferenceImpl("points_ref");
        this.line_ref = new DataReferenceImpl("line_ref");
        this.points_ref.setData((Data)this.points_ff);
        this.line_ref.setData((Data)this.line_ff);
        ConstantMap[] pointsCMap = new ConstantMap[]{new ConstantMap(1.0, Display.Red), new ConstantMap(0.0, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(4.5, Display.PointSize)};
        ConstantMap[] lineCMap = new ConstantMap[]{new ConstantMap(0.0, Display.Red), new ConstantMap((double)0.8f, Display.Green), new ConstantMap(0.0, Display.Blue), new ConstantMap(1.5, Display.LineWidth)};
        this.display.addReference((DataReference)this.points_ref, pointsCMap);
        this.display.addReference((DataReference)this.line_ref, lineCMap);
        JFrame frame = new JFrame("VisAD ".concat(String.valueOf(String.valueOf(this))));
        frame.getContentPane().add(this.display.getComponent());
        ((Component)frame).setSize(300, 300);
        ((Component)frame).setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    public static void main(String[] args) throws VisADException, RemoteException {
        new P2_05(args);
    }
}

