/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.util;

import java.util.Arrays;
import java.util.TreeMap;

public class MathUtil {
    public static final double[] interpLinear(double[] x, double[] y, double[] xi) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y must be the same length");
        }
        if (x.length == 1) {
            throw new IllegalArgumentException("X must contain more than one value");
        }
        double[] dx = new double[x.length - 1];
        double[] dy = new double[x.length - 1];
        double[] slope = new double[x.length - 1];
        double[] intercept = new double[x.length - 1];
        for (int i = 0; i < x.length - 1; ++i) {
            dx[i] = x[i + 1] - x[i];
            if (dx[i] == 0.0) {
                throw new IllegalArgumentException("X must be montotonic. A duplicate x-value was found");
            }
            if (dx[i] < 0.0) {
                throw new IllegalArgumentException("X must be sorted");
            }
            dy[i] = y[i + 1] - y[i];
            slope[i] = dy[i] / dx[i];
            intercept[i] = y[i] - x[i] * slope[i];
        }
        double[] yi = new double[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            if (xi[i] > x[x.length - 1] || xi[i] < x[0]) {
                yi[i] = Double.NaN;
                continue;
            }
            int loc = Arrays.binarySearch(x, xi[i]);
            if (loc < -1) {
                loc = -loc - 2;
                yi[i] = slope[loc] * xi[i] + intercept[loc];
                continue;
            }
            yi[i] = y[loc];
        }
        return yi;
    }

    public static final double[] interpLinear(long[] x, double[] y, long[] xi) throws IllegalArgumentException {
        double[] xd = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            xd[i] = x[i];
        }
        double[] xid = new double[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            xid[i] = xi[i];
        }
        return MathUtil.interpLinear(xd, y, xid);
    }

    public static final int find(double[] array, double valueToFind) {
        return Arrays.binarySearch(array, valueToFind);
    }

    public static double mod(double x, double y) {
        double m = x;
        if (y != 0.0) {
            m = x - y * Math.floor(x / y);
        }
        return m;
    }

    public static double rem(double x, double y) {
        double m = x;
        if (y != 0.0) {
            m = x - y * MathUtil.fix(x / y);
        }
        return m;
    }

    public static double fix(double x) {
        int sign = MathUtil.sign(x);
        double y = 0.0;
        if (sign == -1) {
            y = Math.ceil(x);
        } else if (sign == 1) {
            y = Math.floor(x);
        }
        return y;
    }

    public static int sign(double x) {
        int s = 0;
        if (x > 0.0) {
            s = 1;
        } else if (x < 0.0) {
            s = -1;
        }
        return s;
    }

    public static double[] cumSum(double[] n) {
        double[] buf = new double[n.length];
        for (int i = 0; i < n.length; ++i) {
            buf[i] = i == 0 ? n[0] : buf[i - 1] + n[i];
        }
        return buf;
    }

    public static boolean isEven(double x) {
        double i = MathUtil.rem(x, 2.0);
        boolean even = true;
        if (i != 0.0) {
            even = false;
        }
        return even;
    }

    public static final synchronized int[] uniqueSort(double[] x) {
        TreeMap<Double, Integer> tm = new TreeMap<Double, Integer>();
        for (int i = 0; i < x.length; ++i) {
            Double key = new Double(x[i]);
            boolean exists = tm.containsKey(key);
            if (exists) continue;
            tm.put(key, new Integer(i));
        }
        Object[] values = tm.values().toArray();
        int[] order = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer tmp = (Integer)values[i];
            order[i] = tmp;
        }
        return order;
    }

    public static final synchronized int[] uniqueSort(long[] x) {
        TreeMap<Long, Integer> tm = new TreeMap<Long, Integer>();
        for (int i = 0; i < x.length; ++i) {
            Long key = new Long(x[i]);
            boolean exists = tm.containsKey(key);
            if (exists) continue;
            tm.put(key, new Integer(i));
        }
        Object[] values = tm.values().toArray();
        int[] order = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            Integer tmp = (Integer)values[i];
            order[i] = tmp;
        }
        return order;
    }

    public static final double[] orderVector(double[] values, int[] order) {
        double[] out = new double[order.length];
        for (int i = 1; i < order.length; ++i) {
            out[i] = values[order[i]];
        }
        return out;
    }

    public static final float[] orderVector(float[] values, int[] order) {
        float[] out = new float[order.length];
        for (int i = 1; i < order.length; ++i) {
            out[i] = values[order[i]];
        }
        return out;
    }

    public static final long[] orderVector(long[] values, int[] order) {
        long[] out = new long[order.length];
        for (int i = 1; i < order.length; ++i) {
            out[i] = values[order[i]];
        }
        return out;
    }
}

