/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.util;

import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import org.mbari.util.GmtCalendar;
import org.mbari.util.MathUtil;

public class DateConverter {
    public static final Date doyToDate(double dayOfYear, double year) {
        int month;
        double feb = 28.0;
        double max = 365.0;
        if (DateConverter.isLeap(year)) {
            feb = 29.0;
            max = 366.0;
        }
        double[] daysPerMonth = new double[]{0.0, 31.0, feb, 31.0, 30.0, 31.0, 30.0, 31.0, 31.0, 30.0, 31.0, 30.0, 31.0};
        double[] days = MathUtil.cumSum(daysPerMonth);
        while (Math.floor(dayOfYear) > max) {
            dayOfYear -= max;
            if (DateConverter.isLeap(year += 1.0)) {
                max = 366.0;
                continue;
            }
            max = 365.0;
        }
        for (month = 0; month < Array.getLength(days) && !(dayOfYear < days[month]); ++month) {
        }
        double day = dayOfYear - days[month - 1];
        double hour = (day - Math.floor(day)) * 24.0;
        double minute = (hour - Math.floor(hour)) * 60.0;
        double second = (minute - Math.floor(minute)) * 60.0;
        GmtCalendar gc = new GmtCalendar((int)year, month - 1, (int)Math.floor(day), (int)Math.floor(hour), (int)Math.floor(minute), (int)Math.rint(second));
        return gc.getTime();
    }

    public static final Date doyToDate(int dayOfYear, int year) {
        return DateConverter.doyToDate((double)dayOfYear, (double)year);
    }

    public static final Date doyToDate(float dayOfYear, int year) {
        return DateConverter.doyToDate((double)dayOfYear, (double)year);
    }

    public static final Date doyToDate(double dayOfYear, int year) {
        return DateConverter.doyToDate(dayOfYear, (double)year);
    }

    public static final double utcToSerialDays(long utc) {
        return DateConverter.utcToSerialDays((double)utc);
    }

    public static final double utcToSerialDays(double utc) {
        return utc / 1000.0 / 60.0 / 60.0 / 24.0 + 719529.0;
    }

    public static final long serialDaysToUtc(double serialDay) {
        return (long)((serialDay - 719529.0) * 1000.0 * 60.0 * 60.0 * 24.0);
    }

    public static final boolean isLeap(double year) {
        GregorianCalendar gc = new GregorianCalendar();
        return gc.isLeapYear((int)year);
    }

    public static final boolean isLeap(int year) {
        return DateConverter.isLeap((double)year);
    }

    public static double toSerialDays(Date d) {
        return DateConverter.utcToSerialDays(d.getTime());
    }

    public static void main(String[] args) {
        Date t = DateConverter.doyToDate(3.122, 1999);
        SimpleDateFormat df = new SimpleDateFormat("EEE MMM d yyyy HH:mm:ss zzz");
        System.out.println(df.format(t));
        Date x = DateConverter.doyToDate(322.4444, 1999);
        System.out.println(df.format(x));
        long y = DateConverter.serialDaysToUtc(730330.6456040278);
        System.out.println(df.format(new Date(y)));
        System.out.println("pause");
    }

    public static int dateToDayOfYear(Date date) {
        GmtCalendar gmt = new GmtCalendar(date);
        return gmt.get(6);
    }

    public static int dateToDayOfYear(long millis) {
        GmtCalendar gmt = new GmtCalendar(millis);
        return gmt.get(6);
    }
}

