/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.model.solar;

import java.io.IOException;
import org.mbari.util.GmtCalendar;
import org.mbari.util.SolarPosition;
import org.mbari.util.SolarUtil;

public class FrouinIrradianceModel {
    private double[] wavelength;
    private double[] kO3;
    private double[] E0;

    public FrouinIrradianceModel(double[] lambda) {
        this.wavelength = lambda;
        this.E0 = SolarUtil.getNeckelLabIrradiance(lambda);
        try {
            this.kO3 = SolarUtil.getOzoneAbsorption(lambda);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public double[] calcIrradiance(long millis, double lat, double lon, double TauA865, double Angstrom, double Dobson) {
        double[] wl = this.wavelength;
        double[] E = new double[this.wavelength.length];
        double[] TransG = new double[this.wavelength.length];
        double[] TransA = new double[this.wavelength.length];
        double[] Sa = new double[this.wavelength.length];
        double[] TauMol = new double[this.wavelength.length];
        double[] TauAer = new double[this.wavelength.length];
        int month = new GmtCalendar(millis).get(2) + 1;
        SolarPosition sp = new SolarPosition(millis, lat, lon);
        double EsFactor = 1.0 / sp.distance;
        double SolZen = sp.zenith * (double)180 / Math.PI;
        double SolAz = sp.azimuth * (double)180 / Math.PI;
        if (SolZen < 0.0 || SolZen > 90.0) {
            for (int i = 0; i < E.length; ++i) {
                E[i] = -999.9;
            }
            return E;
        }
        double CosSolZen = Math.cos(SolZen * Math.PI / 180.0);
        if (Dobson <= 0.0) {
            Dobson = SolarUtil.estimDobson(month, lat);
        }
        if (TauA865 <= 0.0) {
            TauA865 = 0.1;
        }
        Angstrom = Angstrom <= 0.0 ? -0.07 : -1.0 * Angstrom;
        double A = 0.008435;
        double B = -1.225E-4;
        double C = 1.4E-4;
        double AsymFac = 0.6666667;
        double Beta = 0.5 * (1.0 + AsymFac);
        double Gamma = 1.0 - AsymFac;
        double As = 0.05 / (1.1 * Math.pow(CosSolZen, 1.4) + 0.15);
        for (int i = 0; i < E.length; ++i) {
            TransG[i] = Math.exp(-this.kO3[i] / (double)1000 * Dobson / CosSolZen);
            double ww = wl[i] / 1000.0;
            double wl4 = Math.pow(ww, 4.0);
            double wl5 = ww * wl4;
            double wl6 = ww * wl5;
            TauMol[i] = A / wl4 + B / wl5 + C / wl6;
            TauAer[i] = TauA865 * Math.pow(wl[i] / 865.0, Angstrom);
            double Tau = TauMol[i] + TauAer[i];
            TransA[i] = Math.exp(-Tau / CosSolZen) * Math.exp((0.52 * TauMol[i] + Beta * TauAer[i]) / CosSolZen);
            Sa[i] = Math.exp(-Tau) * (0.92 * TauMol[i] + Gamma * TauAer[i]);
            E[i] = this.E0[i] * EsFactor * CosSolZen * TransG[i] * TransA[i] / (1.0 - Sa[i] * As);
        }
        return E;
    }

    public double[] calcIrradiance(long millis, double lat, double lon) {
        double TauA865 = -999.0;
        double Angstrom = -999.0;
        double Dobson = -999.0;
        return this.calcIrradiance(millis, lat, lon, TauA865, Angstrom, Dobson);
    }

    public double[] calcIrradiance(int year, int month, int day, double time, double lat, double lon) {
        GmtCalendar gmt = new GmtCalendar(year, month - 1, day, (int)time, 0);
        double TauA865 = -999.0;
        double Angstrom = -999.0;
        double Dobson = -999.0;
        return this.calcIrradiance(gmt.getTime().getTime(), lat, lon, TauA865, Angstrom, Dobson);
    }

    public double[] getWavelength() {
        return this.wavelength;
    }
}

