/*
 * Decompiled with CFR 0.152.
 */
package org.mbari.model.solar;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.mbari.util.SolarUtil;

public class FrouinExtended {
    public static void main(String[] args) {
        int year = 0;
        int month = 0;
        int day = 0;
        double time = 0.0;
        double lat = 0.0;
        double lon = 0.0;
        double TauA865 = 0.0;
        double Angstrom = 0.0;
        double Dobson = 0.0;
        double SolZen = 0.0;
        double[] E = new double[6];
        double[] lambda = new double[]{412.0, 0.0, 443.0, 490.0, 510.0, 555.0, 670.0};
        boolean flag = false;
        if (args.length == 0) {
            flag = false;
            FrouinExtended.testFrouinExtended();
        } else if (args.length == 9) {
            flag = true;
            year = Integer.parseInt(args[0]);
            month = Integer.parseInt(args[1]);
            day = Integer.parseInt(args[2]);
            time = Double.parseDouble(args[3]);
            lat = Double.parseDouble(args[4]);
            lon = Double.parseDouble(args[5]);
            TauA865 = Double.parseDouble(args[6]);
            Angstrom = Double.parseDouble(args[7]);
            Dobson = Double.parseDouble(args[8]);
            E = FrouinExtended.calcSurfSolIrrad(lambda, year, month, day, time, lat, lon, TauA865, Angstrom, Dobson);
        } else if (args.length == 6) {
            flag = true;
            year = Integer.parseInt(args[0]);
            month = Integer.parseInt(args[1]);
            day = Integer.parseInt(args[2]);
            time = Double.parseDouble(args[3]);
            lat = Double.parseDouble(args[4]);
            lon = Double.parseDouble(args[5]);
            E = FrouinExtended.calcSurfSolIrrad(lambda, year, month, day, time, lat, lon);
        } else if (args.length == 3) {
            flag = true;
            long UTC = Long.parseLong(args[0]);
            lat = Double.parseDouble(args[1]);
            lon = Double.parseDouble(args[2]);
            E = FrouinExtended.calcSurfSolIrrad(lambda, UTC, lat, lon);
        }
        if (flag) {
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("        Date: ").append(month).append("/").append(day).append("/").append(year).append(" ").append(time))));
            System.out.println(String.valueOf(String.valueOf(new StringBuffer("    Latitude: ").append(lat).append("   Longitude: ").append(lon))));
            System.out.println("Solar Zenith: ".concat(String.valueOf(String.valueOf(SolZen))));
            for (int i = 0; i < E.length; ++i) {
                System.out.println(String.valueOf(String.valueOf(new StringBuffer("       ").append(lambda[i]).append("[nm]: ").append(E[i]))));
            }
        }
    }

    public static double[] calcSurfSolIrrad(double[] wl, int year, int month, int day, double time, double lat, double lon, double TauA865, double Angstrom, double Dobson) {
        double[] E0 = FrouinExtended.getE0(wl);
        double[] E = new double[wl.length];
        double[] TransG = new double[wl.length];
        double[] TransA = new double[wl.length];
        double[] Sa = new double[wl.length];
        double[] kO3 = FrouinExtended.getKO3(wl);
        double[] TauMol = new double[wl.length];
        double[] TauAer = new double[wl.length];
        double EsFactor = FrouinExtended.varSol(day, month);
        double[] tmp = FrouinExtended.posSol(month, day, time, lon, lat);
        double SolZen = tmp[0];
        double SolAz = tmp[1];
        if (SolZen < 0.0 || SolZen > 90.0) {
            for (int i = 0; i < 6; ++i) {
                E[i] = -999.9;
            }
            return E;
        }
        double CosSolZen = Math.cos(SolZen * Math.PI / 180.0);
        if (Dobson <= 0.0) {
            Dobson = FrouinExtended.estimDobson(month, lat);
        }
        if (TauA865 <= 0.0) {
            TauA865 = 0.1;
        }
        Angstrom = Angstrom <= 0.0 ? -0.07 : -1.0 * Angstrom;
        double A = 0.008435;
        double B = -1.225E-4;
        double C = 1.4E-4;
        double AsymFac = 0.6666667;
        double Beta = 0.5 * (1.0 + AsymFac);
        double Gamma = 1.0 - AsymFac;
        double As = 0.05 / (1.1 * Math.pow(CosSolZen, 1.4) + 0.15);
        for (int i = 0; i < E.length; ++i) {
            TransG[i] = Math.exp(-kO3[i] * Dobson / CosSolZen);
            double ww = wl[i] / 1000.0;
            double wl4 = Math.pow(ww, 4.0);
            double wl5 = ww * wl4;
            double wl6 = ww * wl5;
            TauMol[i] = A / wl4 + B / wl5 + C / wl6;
            TauAer[i] = TauA865 * Math.pow(wl[i] / 865.0, Angstrom);
            double Tau = TauMol[i] + TauAer[i];
            TransA[i] = Math.exp(-Tau / CosSolZen) * Math.exp((0.52 * TauMol[i] + Beta * TauAer[i]) / CosSolZen);
            Sa[i] = Math.exp(-Tau) * (0.92 * TauMol[i] + Gamma * TauAer[i]);
            E[i] = E0[i] * EsFactor * CosSolZen * TransG[i] * TransA[i] / (1.0 - Sa[i] * As);
        }
        return E;
    }

    public static double[] calcSurfSolIrrad(double[] wl, long UTC, double lat, double lon) {
        Date d = new Date(UTC);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        double zoneOffset = cal.get(15);
        double dstOffset = cal.get(16);
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        double hour = (double)cal.get(11) - zoneOffset / 1000.0 / 60.0 / 60.0 - dstOffset / 1000.0 / 60.0 / 60.0;
        double fHour = (double)cal.get(12) / 60.0 + (double)cal.get(13) / 60.0 / 60.0;
        if (hour < 0.0) {
            hour = (double)24 - hour;
            --day;
        } else if (hour >= (double)24) {
            hour -= 24.0;
            ++day;
        }
        double time = hour + fHour;
        double[] E = FrouinExtended.calcSurfSolIrrad(wl, year, month, day, time, lat, lon);
        d = null;
        cal = null;
        return E;
    }

    public static double[] calcSurfSolIrrad(double[] wl, int year, int month, int day, double time, double lat, double lon) {
        double TauA865 = -999.0;
        double Angstrom = -999.0;
        double Dobson = -999.0;
        double[] E = FrouinExtended.calcSurfSolIrrad(wl, year, month, day, time, lat, lon, TauA865, Angstrom, Dobson);
        return E;
    }

    public static double varSol(int jday, int month) {
        int j = month <= 2 ? 31 * (month - 1) + jday : (month > 8 ? 31 * (month - 1) - (month - 2) / 2 - 2 + jday : 31 * (month - 1) - (month - 1) / 2 - 2 + jday);
        double pi = Math.PI;
        double om = 0.9856 * ((double)j - 4.0) * pi / 180.0;
        double dsol = 1.0 / Math.pow(1.0 - 0.01673 * Math.cos(om), 2.0);
        return dsol;
    }

    public static double[] posSol(int month, int jday, double tu, double xlon, double xlat) {
        int ia = 0;
        int nojour = FrouinExtended.dayNumber(jday, month, ia);
        double[] out = FrouinExtended.posFft(nojour, tu, xlon, xlat);
        double asol = out[0];
        double phi0 = out[1];
        if (asol > (double)90) {
            // empty if block
        }
        return out;
    }

    public static double mod(double x, double y) {
        double m = x;
        if (y != 0.0) {
            m = x - y * Math.floor(x / y);
        }
        return m;
    }

    public static int sign(double x) {
        int s = 0;
        if (x > 0.0) {
            s = 1;
        } else if (x < 0.0) {
            s = -1;
        }
        return s;
    }

    public static int dayNumber(int jday, int month, int ia) {
        int j = month <= 2 ? 31 * (month - 1) + jday : (month > 8 ? 31 * (month - 1) - (month - 2) / 2 - 2 + jday : 31 * (month - 1) - (month - 1) / 2 - 2 + jday);
        if (ia != 0 & FrouinExtended.mod(ia, 4.0) == 0.0) {
            ++j;
        }
        return j;
    }

    public static double[] posFft(int j, double tu, double xlon, double xlat) {
        double pi2;
        double pi = Math.PI;
        double fac = pi / 180.0;
        double tsm = tu + xlon / 15.0;
        double xla = xlat * fac;
        double xj = j;
        double tet = 2.0 * pi * xj / 365.0;
        double a1 = 7.5E-5;
        double a2 = 0.001868;
        double a3 = 0.032077;
        double a4 = 0.014615;
        double a5 = 0.040849;
        double et = a1 + a2 * Math.cos(tet) - a3 * Math.sin(tet) - a4 * Math.cos(2.0 * tet) - a5 * Math.sin(2.0 * tet);
        et = et * 12.0 * 60.0 / pi;
        double tsv = tsm + et / 60.0;
        double ah = (tsv -= 12.0) * 15.0 * fac;
        double b1 = 0.006918;
        double b2 = 0.399912;
        double b3 = 0.070257;
        double b4 = 0.006758;
        double b5 = 9.07E-4;
        double b6 = 0.002697;
        double b7 = 0.00148;
        double delta = b1 - b2 * Math.cos(tet) + b3 * Math.sin(tet) - b4 * Math.cos(2.0 * tet) + b5 * Math.sin(2.0 * tet) - b6 * Math.cos(3.0 * tet) + b7 * Math.sin(3.0 * tet);
        double amuzero = Math.sin(xla) * Math.sin(delta) + Math.cos(xla) * Math.cos(delta) * Math.cos(ah);
        double elev = Math.asin(amuzero);
        double az = Math.cos(delta) * Math.sin(ah) / Math.cos(elev);
        if (Math.abs(az) - 1.0 > 0.0) {
            az = FrouinExtended.sign(az);
        }
        double caz = (-Math.cos(xla) * Math.sin(delta) + Math.sin(xla) * Math.cos(delta) * Math.cos(ah)) / Math.cos(elev);
        double azim = Math.asin(az);
        if (caz <= 0.0) {
            azim = pi - azim;
        }
        if (caz > 0.0 & az <= 0.0) {
            azim = (double)2 * pi + azim;
        }
        if ((azim += pi) > (pi2 = 2.0 * pi)) {
            azim -= pi2;
        }
        elev = elev * 180.0 / pi;
        double asol = 90.0 - elev;
        double phi0 = azim / fac;
        double[] out = new double[]{asol, phi0};
        return out;
    }

    public static double estimDobson(int month, double lat) {
        double Dobson;
        double[][] TabDobson = new double[35][12];
        double[] tmpDobson = new double[]{395.0, 395.0, 395.0, 395.0, 395.0, 392.0, 390.0, 387.0, 376.0, 354.0, 322.0, 292.0, 269.0, 254.0, 248.0, 246.0, 247.0, 251.0, 255.0, 260.0, 266.0, 271.0, 277.0, 286.0, 295.0, 306.0, 319.0, 334.0, 344.0, 344.0, 338.0, 331.0, 324.0, 320.0, 316.0, 433.0, 433.0, 433.0, 436.0, 432.0, 428.0, 426.0, 418.0, 402.0, 374.0, 338.0, 303.0, 278.0, 261.0, 251.0, 246.0, 248.0, 250.0, 254.0, 258.0, 262.0, 265.0, 270.0, 278.0, 286.0, 294.0, 303.0, 313.0, 322.0, 325.0, 324.0, 317.0, 306.0, 299.0, 294.0, 467.0, 470.0, 460.0, 459.0, 451.0, 441.0, 433.0, 420.0, 401.0, 377.0, 347.0, 316.0, 291.0, 271.0, 260.0, 254.0, 254.0, 255.0, 257.0, 259.0, 261.0, 264.0, 269.0, 277.0, 284.0, 289.0, 296.0, 305.0, 312.0, 315.0, 317.0, 312.0, 305.0, 299.0, 295.0, 467.0, 465.0, 462.0, 455.0, 444.0, 431.0, 421.0, 410.0, 395.0, 373.0, 348.0, 325.0, 304.0, 287.0, 275.0, 267.0, 261.0, 259.0, 258.0, 259.0, 260.0, 263.0, 271.0, 278.0, 284.0, 289.0, 297.0, 306.0, 314.0, 318.0, 319.0, 313.0, 302.0, 302.0, 302.0, 411.0, 414.0, 416.0, 415.0, 410.0, 406.0, 402.0, 394.0, 382.0, 363.0, 342.0, 324.0, 307.0, 291.0, 279.0, 271.0, 264.0, 260.0, 258.0, 257.0, 258.0, 264.0, 271.0, 281.0, 291.0, 303.0, 312.0, 318.0, 322.0, 323.0, 322.0, 322.0, 322.0, 322.0, 322.0, 371.0, 371.0, 370.0, 368.0, 367.0, 372.0, 375.0, 372.0, 360.0, 341.0, 323.0, 311.0, 301.0, 290.0, 282.0, 275.0, 268.0, 263.0, 259.0, 256.0, 258.0, 264.0, 273.0, 289.0, 306.0, 319.0, 327.0, 328.0, 328.0, 337.0, 337.0, 337.0, 337.0, 337.0, 337.0, 333.0, 332.0, 332.0, 334.0, 338.0, 346.0, 350.0, 346.0, 335.0, 321.0, 310.0, 302.0, 296.0, 289.0, 284.0, 280.0, 274.0, 268.0, 262.0, 259.0, 261.0, 268.0, 279.0, 295.0, 315.0, 331.0, 340.0, 342.0, 338.0, 344.0, 340.0, 340.0, 340.0, 340.0, 340.0, 311.0, 308.0, 308.0, 313.0, 320.0, 327.0, 330.0, 326.0, 319.0, 310.0, 303.0, 298.0, 291.0, 286.0, 283.0, 281.0, 277.0, 273.0, 268.0, 264.0, 266.0, 274.0, 288.0, 306.0, 327.0, 343.0, 353.0, 355.0, 351.0, 339.0, 325.0, 307.0, 294.0, 294.0, 294.0, 283.0, 291.0, 302.0, 308.0, 312.0, 317.0, 318.0, 313.0, 307.0, 300.0, 295.0, 290.0, 284.0, 279.0, 279.0, 279.0, 278.0, 276.0, 272.0, 270.0, 273.0, 282.0, 295.0, 313.0, 333.0, 348.0, 360.0, 367.0, 368.0, 353.0, 324.0, 291.0, 267.0, 253.0, 230.0, 299.0, 299.0, 299.0, 309.0, 315.0, 317.0, 317.0, 312.0, 302.0, 291.0, 283.0, 280.0, 275.0, 270.0, 268.0, 267.0, 263.0, 263.0, 265.0, 269.0, 277.0, 287.0, 301.0, 317.0, 336.0, 354.0, 371.0, 387.0, 402.0, 402.0, 374.0, 333.0, 294.0, 274.0, 259.0, 314.0, 314.0, 314.0, 314.0, 332.0, 332.0, 327.0, 322.0, 311.0, 297.0, 284.0, 276.0, 270.0, 263.0, 261.0, 260.0, 258.0, 259.0, 264.0, 270.0, 278.0, 286.0, 298.0, 311.0, 323.0, 335.0, 350.0, 366.0, 381.0, 390.0, 388.0, 376.0, 357.0, 346.0, 341.0, 358.0, 358.0, 358.0, 358.0, 358.0, 358.0, 353.0, 349.0, 338.0, 320.0, 299.0, 281.0, 267.0, 256.0, 252.0, 251.0, 251.0, 253.0, 257.0, 264.0, 272.0, 279.0, 287.0, 297.0, 307.0, 318.0, 332.0, 347.0, 358.0, 365.0, 366.0, 364.0, 358.0, 356.0, 353.0};
        int n = -1;
        for (int c = 0; c < 12; ++c) {
            for (int r = 0; r < 35; ++r) {
                TabDobson[r][c] = tmpDobson[++n];
            }
        }
        --month;
        if (lat >= (double)85) {
            Dobson = TabDobson[0][month];
        } else if (lat <= (double)-85) {
            Dobson = TabDobson[34][month];
        } else if (lat >= 0.0) {
            int i1 = 17 - (int)(lat / 5.0);
            int i2 = i1 + 1;
            double fac = (TabDobson[i2][month] - TabDobson[i1][month]) / -5.0;
            double diffLat = lat - (90.0 - (double)i1 * 5.0);
            Dobson = TabDobson[i1][month] + fac * diffLat;
        } else {
            int i1 = 18 - (int)(lat / 5.0);
            int i2 = i1 + 1;
            double fac = (TabDobson[i2][month] - TabDobson[i1][month]) / -5.0;
            double diffLat = lat - (90.0 - (double)i1 * 5.0);
            Dobson = TabDobson[i1][month] + fac * diffLat;
        }
        return Dobson;
    }

    public static void testFrouinExtended() {
        int year = 1998;
        int[] month = new int[]{1, 7};
        int[] day = new int[]{10, 20};
        double[] time = new double[]{9.0, 12.0};
        double[] lat = new double[]{0.0, 40.0};
        double[] E = new double[6];
        double[] out = new double[2];
        double TauA865 = 0.1;
        double Angstrom = 1.0;
        double Dobson = 300.0;
        double lon = 0.0;
        DecimalFormat df1 = new DecimalFormat();
        df1.setMaximumFractionDigits(3);
        df1.setMinimumFractionDigits(3);
        DecimalFormat df2 = new DecimalFormat();
        df2.setMaximumFractionDigits(2);
        df2.setMinimumFractionDigits(2);
        double[] lambda = new double[]{412.0, 443.0, 490.0, 510.0, 555.0, 670.0};
        for (int m = 0; m < 2; ++m) {
            for (int d = 0; d < 2; ++d) {
                for (int t = 0; t < 2; ++t) {
                    for (int L = 0; L < 2; ++L) {
                        out = FrouinExtended.posSol(month[m], day[d], time[t], lon, lat[L]);
                        double SolZen = out[0];
                        E = FrouinExtended.calcSurfSolIrrad(lambda, year, month[m], day[d], time[t], lat[L], lon, TauA865, Angstrom, Dobson);
                        System.out.print(String.valueOf(String.valueOf(new StringBuffer(String.valueOf(String.valueOf(year))).append(" ").append(month[m]).append(" ").append(day[d]).append(" ").append(df1.format(time[t])).append(" ").append(df1.format(lat[L])).append(" ").append(df1.format(lon)).append(" ").append(df2.format(SolZen)).append(" "))));
                        for (int i = 0; i < 6; ++i) {
                            System.out.print(String.valueOf(String.valueOf(df2.format(E[i]))).concat(" "));
                        }
                        System.out.println();
                    }
                }
            }
        }
    }

    public static double[] getE0(double[] lambda) {
        return SolarUtil.getNeckelLabIrradiance(lambda);
    }

    public static double[] getKO3(double[] lambda) {
        double[] kO3 = null;
        try {
            kO3 = SolarUtil.getOzoneAbsorption(lambda);
            for (int i = 0; i < kO3.length; ++i) {
                kO3[i] = kO3[i] / (double)1000;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return kO3;
    }
}

